/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.AddNotificationChannelsResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerException;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ConflictException;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.GetNotificationConfigurationRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetNotificationConfigurationResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetPolicyResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.InternalServerException;
import software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.PutPermissionResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.RemoveNotificationChannelResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.RemovePermissionResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeguruprofiler.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.SubmitFeedbackResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.TagResourceRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.TagResourceResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ThrottlingException;
import software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.UntagResourceResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ValidationException;
import software.amazon.awssdk.services.codeguruprofiler.paginators.GetFindingsReportAccountSummaryIterable;
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListFindingsReportsIterable;
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable;
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable;

/**
 * Service client for accessing Amazon CodeGuru Profiler. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This section provides documentation for the Amazon CodeGuru Profiler API operations.
 * </p>
 * <p>
 * Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides recommendations
 * that can help you fine-tune your application performance. Using machine learning algorithms, CodeGuru Profiler can
 * help you find your most expensive lines of code and suggest ways you can improve efficiency and remove CPU
 * bottlenecks.
 * </p>
 * <p>
 * Amazon CodeGuru Profiler provides different visualizations of profiling data to help you identify what code is
 * running on the CPU, see how much time is consumed, and suggest ways to reduce CPU utilization.
 * </p>
 * <note>
 * <p>
 * Amazon CodeGuru Profiler currently supports applications written in all Java virtual machine (JVM) languages and
 * Python. While CodeGuru Profiler supports both visualizations and recommendations for applications written in Java, it
 * can also generate visualizations and a subset of recommendations for applications written in other JVM languages and
 * Python.
 * </p>
 * </note>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/what-is-codeguru-profiler.html">What is Amazon CodeGuru
 * Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodeGuruProfilerClient extends AwsClient {
    String SERVICE_NAME = "codeguru-profiler";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codeguru-profiler";

    /**
     * <p>
     * Add up to 2 anomaly notifications channels for a profiling group.
     * </p>
     *
     * @param addNotificationChannelsRequest
     *        The structure representing the AddNotificationChannelsRequest.
     * @return Result of the AddNotificationChannels operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service
     *         Quotas</a> to request a service quota increase.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.AddNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/AddNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default AddNotificationChannelsResponse addNotificationChannels(AddNotificationChannelsRequest addNotificationChannelsRequest)
            throws ServiceQuotaExceededException, InternalServerException, ConflictException, ValidationException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add up to 2 anomaly notifications channels for a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddNotificationChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link AddNotificationChannelsRequest#builder()}
     * </p>
     *
     * @param addNotificationChannelsRequest
     *        A {@link Consumer} that will call methods on {@link AddNotificationChannelsRequest.Builder} to create a
     *        request. The structure representing the AddNotificationChannelsRequest.
     * @return Result of the AddNotificationChannels operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service
     *         Quotas</a> to request a service quota increase.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.AddNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/AddNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default AddNotificationChannelsResponse addNotificationChannels(
            Consumer<AddNotificationChannelsRequest.Builder> addNotificationChannelsRequest)
            throws ServiceQuotaExceededException, InternalServerException, ConflictException, ValidationException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return addNotificationChannels(AddNotificationChannelsRequest.builder().applyMutation(addNotificationChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the time series of values for a requested list of frame metrics from a time period.
     * </p>
     *
     * @param batchGetFrameMetricDataRequest
     *        The structure representing the BatchGetFrameMetricDataRequest.
     * @return Result of the BatchGetFrameMetricData operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.BatchGetFrameMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/BatchGetFrameMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFrameMetricDataResponse batchGetFrameMetricData(BatchGetFrameMetricDataRequest batchGetFrameMetricDataRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the time series of values for a requested list of frame metrics from a time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFrameMetricDataRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetFrameMetricDataRequest#builder()}
     * </p>
     *
     * @param batchGetFrameMetricDataRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetFrameMetricDataRequest.Builder} to create a
     *        request. The structure representing the BatchGetFrameMetricDataRequest.
     * @return Result of the BatchGetFrameMetricData operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.BatchGetFrameMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/BatchGetFrameMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFrameMetricDataResponse batchGetFrameMetricData(
            Consumer<BatchGetFrameMetricDataRequest.Builder> batchGetFrameMetricDataRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return batchGetFrameMetricData(BatchGetFrameMetricDataRequest.builder().applyMutation(batchGetFrameMetricDataRequest)
                .build());
    }

    /**
     * <p>
     * Used by profiler agents to report their current state and to receive remote configuration updates. For example,
     * <code>ConfigureAgent</code> can be used to tell an agent whether to profile or not and for how long to return
     * profiling data.
     * </p>
     *
     * @param configureAgentRequest
     *        The structure representing the configureAgentRequest.
     * @return Result of the ConfigureAgent operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ConfigureAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureAgentResponse configureAgent(ConfigureAgentRequest configureAgentRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by profiler agents to report their current state and to receive remote configuration updates. For example,
     * <code>ConfigureAgent</code> can be used to tell an agent whether to profile or not and for how long to return
     * profiling data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfigureAgentRequest.Builder} avoiding the need to
     * create one manually via {@link ConfigureAgentRequest#builder()}
     * </p>
     *
     * @param configureAgentRequest
     *        A {@link Consumer} that will call methods on {@link ConfigureAgentRequest.Builder} to create a request.
     *        The structure representing the configureAgentRequest.
     * @return Result of the ConfigureAgent operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ConfigureAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfigureAgentResponse configureAgent(Consumer<ConfigureAgentRequest.Builder> configureAgentRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return configureAgent(ConfigureAgentRequest.builder().applyMutation(configureAgentRequest).build());
    }

    /**
     * <p>
     * Creates a profiling group.
     * </p>
     *
     * @param createProfilingGroupRequest
     *        The structure representing the createProfiliingGroupRequest.
     * @return Result of the CreateProfilingGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service
     *         Quotas</a> to request a service quota increase.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.CreateProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfilingGroupResponse createProfilingGroup(CreateProfilingGroupRequest createProfilingGroupRequest)
            throws ServiceQuotaExceededException, InternalServerException, ConflictException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProfilingGroupRequest#builder()}
     * </p>
     *
     * @param createProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfilingGroupRequest.Builder} to create a
     *        request. The structure representing the createProfiliingGroupRequest.
     * @return Result of the CreateProfilingGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service
     *         Quotas</a> to request a service quota increase.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.CreateProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfilingGroupResponse createProfilingGroup(
            Consumer<CreateProfilingGroupRequest.Builder> createProfilingGroupRequest) throws ServiceQuotaExceededException,
            InternalServerException, ConflictException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        return createProfilingGroup(CreateProfilingGroupRequest.builder().applyMutation(createProfilingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a profiling group.
     * </p>
     *
     * @param deleteProfilingGroupRequest
     *        The structure representing the deleteProfilingGroupRequest.
     * @return Result of the DeleteProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DeleteProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfilingGroupResponse deleteProfilingGroup(DeleteProfilingGroupRequest deleteProfilingGroupRequest)
            throws InternalServerException, ConflictException, ValidationException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProfilingGroupRequest#builder()}
     * </p>
     *
     * @param deleteProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfilingGroupRequest.Builder} to create a
     *        request. The structure representing the deleteProfilingGroupRequest.
     * @return Result of the DeleteProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DeleteProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfilingGroupResponse deleteProfilingGroup(
            Consumer<DeleteProfilingGroupRequest.Builder> deleteProfilingGroupRequest) throws InternalServerException,
            ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        return deleteProfilingGroup(DeleteProfilingGroupRequest.builder().applyMutation(deleteProfilingGroupRequest).build());
    }

    /**
     * <p>
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> object that contains information about the requested profiling group.
     * </p>
     *
     * @param describeProfilingGroupRequest
     *        The structure representing the describeProfilingGroupRequest.
     * @return Result of the DescribeProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DescribeProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProfilingGroupResponse describeProfilingGroup(DescribeProfilingGroupRequest describeProfilingGroupRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> object that contains information about the requested profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProfilingGroupRequest#builder()}
     * </p>
     *
     * @param describeProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProfilingGroupRequest.Builder} to create a
     *        request. The structure representing the describeProfilingGroupRequest.
     * @return Result of the DescribeProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.DescribeProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProfilingGroupResponse describeProfilingGroup(
            Consumer<DescribeProfilingGroupRequest.Builder> describeProfilingGroupRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return describeProfilingGroup(DescribeProfilingGroupRequest.builder().applyMutation(describeProfilingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
     * <code>FindingsReportSummary</code> </a> objects that contain analysis results for all profiling groups in your
     * AWS account.
     * </p>
     *
     * @param getFindingsReportAccountSummaryRequest
     *        The structure representing the GetFindingsReportAccountSummaryRequest.
     * @return Result of the GetFindingsReportAccountSummary operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetFindingsReportAccountSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetFindingsReportAccountSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportAccountSummaryResponse getFindingsReportAccountSummary(
            GetFindingsReportAccountSummaryRequest getFindingsReportAccountSummaryRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
     * <code>FindingsReportSummary</code> </a> objects that contain analysis results for all profiling groups in your
     * AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsReportAccountSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetFindingsReportAccountSummaryRequest#builder()}
     * </p>
     *
     * @param getFindingsReportAccountSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsReportAccountSummaryRequest.Builder} to
     *        create a request. The structure representing the GetFindingsReportAccountSummaryRequest.
     * @return Result of the GetFindingsReportAccountSummary operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetFindingsReportAccountSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetFindingsReportAccountSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportAccountSummaryResponse getFindingsReportAccountSummary(
            Consumer<GetFindingsReportAccountSummaryRequest.Builder> getFindingsReportAccountSummaryRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return getFindingsReportAccountSummary(GetFindingsReportAccountSummaryRequest.builder()
                .applyMutation(getFindingsReportAccountSummaryRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
     * <code>FindingsReportSummary</code> </a> objects that contain analysis results for all profiling groups in your
     * AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFindingsReportAccountSummary(software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.GetFindingsReportAccountSummaryIterable responses = client.getFindingsReportAccountSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.GetFindingsReportAccountSummaryIterable responses = client
     *             .getFindingsReportAccountSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.GetFindingsReportAccountSummaryIterable responses = client.getFindingsReportAccountSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingsReportAccountSummary(software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getFindingsReportAccountSummaryRequest
     *        The structure representing the GetFindingsReportAccountSummaryRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetFindingsReportAccountSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetFindingsReportAccountSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportAccountSummaryIterable getFindingsReportAccountSummaryPaginator(
            GetFindingsReportAccountSummaryRequest getFindingsReportAccountSummaryRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return new GetFindingsReportAccountSummaryIterable(this, getFindingsReportAccountSummaryRequest);
    }

    /**
     * <p>
     * Returns a list of <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
     * <code>FindingsReportSummary</code> </a> objects that contain analysis results for all profiling groups in your
     * AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFindingsReportAccountSummary(software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.GetFindingsReportAccountSummaryIterable responses = client.getFindingsReportAccountSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.GetFindingsReportAccountSummaryIterable responses = client
     *             .getFindingsReportAccountSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.GetFindingsReportAccountSummaryIterable responses = client.getFindingsReportAccountSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingsReportAccountSummary(software.amazon.awssdk.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsReportAccountSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetFindingsReportAccountSummaryRequest#builder()}
     * </p>
     *
     * @param getFindingsReportAccountSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsReportAccountSummaryRequest.Builder} to
     *        create a request. The structure representing the GetFindingsReportAccountSummaryRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetFindingsReportAccountSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetFindingsReportAccountSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsReportAccountSummaryIterable getFindingsReportAccountSummaryPaginator(
            Consumer<GetFindingsReportAccountSummaryRequest.Builder> getFindingsReportAccountSummaryRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return getFindingsReportAccountSummaryPaginator(GetFindingsReportAccountSummaryRequest.builder()
                .applyMutation(getFindingsReportAccountSummaryRequest).build());
    }

    /**
     * <p>
     * Get the current configuration for anomaly notifications for a profiling group.
     * </p>
     *
     * @param getNotificationConfigurationRequest
     *        The structure representing the GetNotificationConfigurationRequest.
     * @return Result of the GetNotificationConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationConfigurationResponse getNotificationConfiguration(
            GetNotificationConfigurationRequest getNotificationConfigurationRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the current configuration for anomaly notifications for a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetNotificationConfigurationRequest.Builder} to create
     *        a request. The structure representing the GetNotificationConfigurationRequest.
     * @return Result of the GetNotificationConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationConfigurationResponse getNotificationConfiguration(
            Consumer<GetNotificationConfigurationRequest.Builder> getNotificationConfigurationRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return getNotificationConfiguration(GetNotificationConfigurationRequest.builder()
                .applyMutation(getNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the JSON-formatted resource-based policy on a profiling group.
     * </p>
     *
     * @param getPolicyRequest
     *        The structure representing the <code>getPolicyRequest</code>.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the JSON-formatted resource-based policy on a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request. The
     *        structure representing the <code>getPolicyRequest</code>.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPolicyResponse getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects
     * posted agent profiles for a profiling group into aggregated profiles.
     * </p>
     * 
     * <pre>
     * <code> &lt;note&gt; &lt;p&gt; Because aggregated profiles expire over time &lt;code&gt;GetProfile&lt;/code&gt; is not idempotent. &lt;/p&gt; &lt;/note&gt; &lt;p&gt; Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: &lt;code&gt;startTime&lt;/code&gt;, &lt;code&gt;endTime&lt;/code&gt;, &lt;code&gt;period&lt;/code&gt;. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only &lt;code&gt;period&lt;/code&gt;, the latest aggregated profile is returned. &lt;/p&gt; &lt;p&gt; Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html&quot;&gt; &lt;code&gt;AggregatedProfileTime&lt;/code&gt; &lt;/a&gt;. The aggregated profile's aggregation period determines how long it is retained by CodeGuru Profiler. &lt;/p&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 1 hour, the aggregated profile is retained for 60 days. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 1 day, the aggregated profile is retained for 3 years. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;p&gt;There are two use cases for calling &lt;code&gt;GetProfile&lt;/code&gt;.&lt;/p&gt; &lt;ol&gt; &lt;li&gt; &lt;p&gt; If you want to return an aggregated profile that already exists, use &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html&quot;&gt; &lt;code&gt;ListProfileTimes&lt;/code&gt; &lt;/a&gt; to view the time ranges of existing aggregated profiles. Use them in a &lt;code&gt;GetProfile&lt;/code&gt; request to return a specific, existing aggregated profile. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile. &lt;/p&gt; &lt;p&gt; If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned. &lt;/p&gt; &lt;/li&gt; &lt;/ol&gt; </code>
     * </pre>
     *
     * @param getProfileRequest
     *        The structure representing the getProfileRequest.
     * @return Result of the GetProfile operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects
     * posted agent profiles for a profiling group into aggregated profiles.
     * </p>
     * 
     * <pre>
     * <code> &lt;note&gt; &lt;p&gt; Because aggregated profiles expire over time &lt;code&gt;GetProfile&lt;/code&gt; is not idempotent. &lt;/p&gt; &lt;/note&gt; &lt;p&gt; Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: &lt;code&gt;startTime&lt;/code&gt;, &lt;code&gt;endTime&lt;/code&gt;, &lt;code&gt;period&lt;/code&gt;. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only &lt;code&gt;period&lt;/code&gt;, the latest aggregated profile is returned. &lt;/p&gt; &lt;p&gt; Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html&quot;&gt; &lt;code&gt;AggregatedProfileTime&lt;/code&gt; &lt;/a&gt;. The aggregated profile's aggregation period determines how long it is retained by CodeGuru Profiler. &lt;/p&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 1 hour, the aggregated profile is retained for 60 days. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 1 day, the aggregated profile is retained for 3 years. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;p&gt;There are two use cases for calling &lt;code&gt;GetProfile&lt;/code&gt;.&lt;/p&gt; &lt;ol&gt; &lt;li&gt; &lt;p&gt; If you want to return an aggregated profile that already exists, use &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html&quot;&gt; &lt;code&gt;ListProfileTimes&lt;/code&gt; &lt;/a&gt; to view the time ranges of existing aggregated profiles. Use them in a &lt;code&gt;GetProfile&lt;/code&gt; request to return a specific, existing aggregated profile. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile. &lt;/p&gt; &lt;p&gt; If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned. &lt;/p&gt; &lt;/li&gt; &lt;/ol&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetProfileRequest.Builder} to create a request. The
     *        structure representing the getProfileRequest.
     * @return Result of the GetProfile operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html">
     * <code>Recommendation</code> </a> objects that contain recommendations for a profiling group for a given time
     * period. A list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html">
     * <code>Anomaly</code> </a> objects that contains details about anomalies detected in the profiling group for the
     * same time period is also returned.
     * </p>
     *
     * @param getRecommendationsRequest
     *        The structure representing the GetRecommendationsRequest.
     * @return Result of the GetRecommendations operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationsResponse getRecommendations(GetRecommendationsRequest getRecommendationsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html">
     * <code>Recommendation</code> </a> objects that contain recommendations for a profiling group for a given time
     * period. A list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html">
     * <code>Anomaly</code> </a> objects that contains details about anomalies detected in the profiling group for the
     * same time period is also returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRecommendationsRequest#builder()}
     * </p>
     *
     * @param getRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommendationsRequest.Builder} to create a
     *        request. The structure representing the GetRecommendationsRequest.
     * @return Result of the GetRecommendations operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationsResponse getRecommendations(Consumer<GetRecommendationsRequest.Builder> getRecommendationsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return getRecommendations(GetRecommendationsRequest.builder().applyMutation(getRecommendationsRequest).build());
    }

    /**
     * <p>
     * List the available reports for a given profiling group and time range.
     * </p>
     *
     * @param listFindingsReportsRequest
     *        The structure representing the ListFindingsReportsRequest.
     * @return Result of the ListFindingsReports operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListFindingsReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListFindingsReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsReportsResponse listFindingsReports(ListFindingsReportsRequest listFindingsReportsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the available reports for a given profiling group and time range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingsReportsRequest#builder()}
     * </p>
     *
     * @param listFindingsReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsReportsRequest.Builder} to create a
     *        request. The structure representing the ListFindingsReportsRequest.
     * @return Result of the ListFindingsReports operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListFindingsReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListFindingsReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsReportsResponse listFindingsReports(
            Consumer<ListFindingsReportsRequest.Builder> listFindingsReportsRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return listFindingsReports(ListFindingsReportsRequest.builder().applyMutation(listFindingsReportsRequest).build());
    }

    /**
     * <p>
     * List the available reports for a given profiling group and time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingsReports(software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListFindingsReportsIterable responses = client.listFindingsReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListFindingsReportsIterable responses = client
     *             .listFindingsReportsPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListFindingsReportsIterable responses = client.listFindingsReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingsReports(software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingsReportsRequest
     *        The structure representing the ListFindingsReportsRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListFindingsReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListFindingsReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsReportsIterable listFindingsReportsPaginator(ListFindingsReportsRequest listFindingsReportsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return new ListFindingsReportsIterable(this, listFindingsReportsRequest);
    }

    /**
     * <p>
     * List the available reports for a given profiling group and time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingsReports(software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListFindingsReportsIterable responses = client.listFindingsReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListFindingsReportsIterable responses = client
     *             .listFindingsReportsPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListFindingsReportsIterable responses = client.listFindingsReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingsReports(software.amazon.awssdk.services.codeguruprofiler.model.ListFindingsReportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsReportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingsReportsRequest#builder()}
     * </p>
     *
     * @param listFindingsReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsReportsRequest.Builder} to create a
     *        request. The structure representing the ListFindingsReportsRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListFindingsReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListFindingsReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingsReportsIterable listFindingsReportsPaginator(
            Consumer<ListFindingsReportsRequest.Builder> listFindingsReportsRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return listFindingsReportsPaginator(ListFindingsReportsRequest.builder().applyMutation(listFindingsReportsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     *
     * @param listProfileTimesRequest
     *        The structure representing the listProfileTimesRequest.
     * @return Result of the ListProfileTimes operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesResponse listProfileTimes(ListProfileTimesRequest listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileTimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileTimesRequest#builder()}
     * </p>
     *
     * @param listProfileTimesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileTimesRequest.Builder} to create a request.
     *        The structure representing the listProfileTimesRequest.
     * @return Result of the ListProfileTimes operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesResponse listProfileTimes(Consumer<ListProfileTimesRequest.Builder> listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfileTimes(ListProfileTimesRequest.builder().applyMutation(listProfileTimesRequest).build());
    }

    /**
     * <p>
     * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client
     *             .listProfileTimesPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfileTimesRequest
     *        The structure representing the listProfileTimesRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesIterable listProfileTimesPaginator(ListProfileTimesRequest listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return new ListProfileTimesIterable(this, listProfileTimesRequest);
    }

    /**
     * <p>
     * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client
     *             .listProfileTimesPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesIterable responses = client.listProfileTimesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileTimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileTimesRequest#builder()}
     * </p>
     *
     * @param listProfileTimesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileTimesRequest.Builder} to create a request.
     *        The structure representing the listProfileTimesRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfileTimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesIterable listProfileTimesPaginator(Consumer<ListProfileTimesRequest.Builder> listProfileTimesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfileTimesPaginator(ListProfileTimesRequest.builder().applyMutation(listProfileTimesRequest).build());
    }

    /**
     * <p>
     * Returns a list of profiling groups. The profiling groups are returned as <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects.
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        The structure representing the listProfilingGroupsRequest.
     * @return Result of the ListProfilingGroups operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsResponse listProfilingGroups(ListProfilingGroupsRequest listProfilingGroupsRequest)
            throws InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of profiling groups. The profiling groups are returned as <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfilingGroupsRequest#builder()}
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilingGroupsRequest.Builder} to create a
     *        request. The structure representing the listProfilingGroupsRequest.
     * @return Result of the ListProfilingGroups operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsResponse listProfilingGroups(
            Consumer<ListProfilingGroupsRequest.Builder> listProfilingGroupsRequest) throws InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfilingGroups(ListProfilingGroupsRequest.builder().applyMutation(listProfilingGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of profiling groups. The profiling groups are returned as <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client
     *             .listProfilingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        The structure representing the listProfilingGroupsRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsIterable listProfilingGroupsPaginator(ListProfilingGroupsRequest listProfilingGroupsRequest)
            throws InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return new ListProfilingGroupsIterable(this, listProfilingGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of profiling groups. The profiling groups are returned as <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * <code>ProfilingGroupDescription</code> </a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client
     *             .listProfilingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsIterable responses = client.listProfilingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfilingGroupsRequest#builder()}
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilingGroupsRequest.Builder} to create a
     *        request. The structure representing the listProfilingGroupsRequest.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListProfilingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsIterable listProfilingGroupsPaginator(
            Consumer<ListProfilingGroupsRequest.Builder> listProfilingGroupsRequest) throws InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listProfilingGroupsPaginator(ListProfilingGroupsRequest.builder().applyMutation(listProfilingGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the tags that are assigned to a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags that are assigned to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is
     * created with this profiling data, use <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html"> <code>GetProfile</code>
     * </a>.
     * </p>
     *
     * @param postAgentProfileRequest
     *        The structure representing the postAgentProfileRequest.
     * @return Result of the PostAgentProfile operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.PostAgentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default PostAgentProfileResponse postAgentProfile(PostAgentProfileRequest postAgentProfileRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is
     * created with this profiling data, use <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html"> <code>GetProfile</code>
     * </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostAgentProfileRequest.Builder} avoiding the need
     * to create one manually via {@link PostAgentProfileRequest#builder()}
     * </p>
     *
     * @param postAgentProfileRequest
     *        A {@link Consumer} that will call methods on {@link PostAgentProfileRequest.Builder} to create a request.
     *        The structure representing the postAgentProfileRequest.
     * @return Result of the PostAgentProfile operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.PostAgentProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default PostAgentProfileResponse postAgentProfile(Consumer<PostAgentProfileRequest.Builder> postAgentProfileRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return postAgentProfile(PostAgentProfileRequest.builder().applyMutation(postAgentProfileRequest).build());
    }

    /**
     * <p>
     * Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a
     * profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action
     * group and the roles and users in the <code>principals</code> parameter.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt; The one supported action group that can be added is &lt;code&gt;agentPermission&lt;/code&gt; which grants &lt;code&gt;ConfigureAgent&lt;/code&gt; and &lt;code&gt;PostAgent&lt;/code&gt; permissions. For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html&quot;&gt;Resource-based policies in CodeGuru Profiler&lt;/a&gt; in the &lt;i&gt;Amazon CodeGuru Profiler User Guide&lt;/i&gt;, &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html&quot;&gt; &lt;code&gt;ConfigureAgent&lt;/code&gt; &lt;/a&gt;, and &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html&quot;&gt; &lt;code&gt;PostAgentProfile&lt;/code&gt; &lt;/a&gt;. &lt;/p&gt; &lt;p&gt; The first time you call &lt;code&gt;PutPermission&lt;/code&gt; on a profiling group, do not specify a &lt;code&gt;revisionId&lt;/code&gt; because it doesn't have a resource-based policy. Subsequent calls must provide a &lt;code&gt;revisionId&lt;/code&gt; to specify which revision of the resource-based policy to add the permissions to. &lt;/p&gt; &lt;p&gt; The response contains the profiling group's JSON-formatted resource policy. &lt;/p&gt; </code>
     * </pre>
     *
     * @param putPermissionRequest
     *        The structure representing the <code>putPermissionRequest</code>.
     * @return Result of the PutPermission operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.PutPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PutPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPermissionResponse putPermission(PutPermissionRequest putPermissionRequest) throws InternalServerException,
            ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a
     * profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action
     * group and the roles and users in the <code>principals</code> parameter.
     * </p>
     * 
     * <pre>
     * <code> &lt;p&gt; The one supported action group that can be added is &lt;code&gt;agentPermission&lt;/code&gt; which grants &lt;code&gt;ConfigureAgent&lt;/code&gt; and &lt;code&gt;PostAgent&lt;/code&gt; permissions. For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html&quot;&gt;Resource-based policies in CodeGuru Profiler&lt;/a&gt; in the &lt;i&gt;Amazon CodeGuru Profiler User Guide&lt;/i&gt;, &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html&quot;&gt; &lt;code&gt;ConfigureAgent&lt;/code&gt; &lt;/a&gt;, and &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html&quot;&gt; &lt;code&gt;PostAgentProfile&lt;/code&gt; &lt;/a&gt;. &lt;/p&gt; &lt;p&gt; The first time you call &lt;code&gt;PutPermission&lt;/code&gt; on a profiling group, do not specify a &lt;code&gt;revisionId&lt;/code&gt; because it doesn't have a resource-based policy. Subsequent calls must provide a &lt;code&gt;revisionId&lt;/code&gt; to specify which revision of the resource-based policy to add the permissions to. &lt;/p&gt; &lt;p&gt; The response contains the profiling group's JSON-formatted resource policy. &lt;/p&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link PutPermissionRequest#builder()}
     * </p>
     *
     * @param putPermissionRequest
     *        A {@link Consumer} that will call methods on {@link PutPermissionRequest.Builder} to create a request. The
     *        structure representing the <code>putPermissionRequest</code>.
     * @return Result of the PutPermission operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.PutPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PutPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default PutPermissionResponse putPermission(Consumer<PutPermissionRequest.Builder> putPermissionRequest)
            throws InternalServerException, ConflictException, ValidationException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return putPermission(PutPermissionRequest.builder().applyMutation(putPermissionRequest).build());
    }

    /**
     * <p>
     * Remove one anomaly notifications channel for a profiling group.
     * </p>
     *
     * @param removeNotificationChannelRequest
     *        The structure representing the RemoveNotificationChannelRequest.
     * @return Result of the RemoveNotificationChannel operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.RemoveNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/RemoveNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveNotificationChannelResponse removeNotificationChannel(
            RemoveNotificationChannelRequest removeNotificationChannelRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one anomaly notifications channel for a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveNotificationChannelRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveNotificationChannelRequest#builder()}
     * </p>
     *
     * @param removeNotificationChannelRequest
     *        A {@link Consumer} that will call methods on {@link RemoveNotificationChannelRequest.Builder} to create a
     *        request. The structure representing the RemoveNotificationChannelRequest.
     * @return Result of the RemoveNotificationChannel operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.RemoveNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/RemoveNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveNotificationChannelResponse removeNotificationChannel(
            Consumer<RemoveNotificationChannelRequest.Builder> removeNotificationChannelRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        return removeNotificationChannel(RemoveNotificationChannelRequest.builder()
                .applyMutation(removeNotificationChannelRequest).build());
    }

    /**
     * <p>
     * Removes permissions from a profiling group's resource-based policy that are provided using an action group. The
     * one supported action group that can be removed is <code>agentPermission</code> which grants
     * <code>ConfigureAgent</code> and <code>PostAgent</code> permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based
     * policies in CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>, <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * <code>ConfigureAgent</code> </a>, and <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * <code>PostAgentProfile</code> </a>.
     * </p>
     *
     * @param removePermissionRequest
     *        <pre>
     * <code> The structure representing the &lt;code&gt;removePermissionRequest&lt;/code&gt;.&lt;/p&gt; </code>
     * @return Result of the RemovePermission operation returned by the service.
     * @throws InternalServerException The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException The parameter is not valid.
     * @throws ThrottlingException The request was denied due to request throttling.
     * @throws ResourceNotFoundException The resource specified in the request does not exist.
     * @throws SdkException  Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     * @throws SdkClientException  If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/RemovePermission" target="_top">AWS API Documentation</a>
     */
    default RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest)
            throws InternalServerException, ConflictException, ValidationException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes permissions from a profiling group's resource-based policy that are provided using an action group. The
     * one supported action group that can be removed is <code>agentPermission</code> which grants
     * <code>ConfigureAgent</code> and <code>PostAgent</code> permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based
     * policies in CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>, <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * <code>ConfigureAgent</code> </a>, and <a
     * href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * <code>PostAgentProfile</code> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on {@link RemovePermissionRequest.Builder} to create a request.
     * 
     *        <pre>
     * <code> The structure representing the &lt;code&gt;removePermissionRequest&lt;/code&gt;.&lt;/p&gt; </code>
     * @return Result of the RemovePermission operation returned by the service.
     * @throws InternalServerException The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException The parameter is not valid.
     * @throws ThrottlingException The request was denied due to request throttling.
     * @throws ResourceNotFoundException The resource specified in the request does not exist.
     * @throws SdkException  Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     * @throws SdkClientException  If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/RemovePermission" target="_top">AWS API Documentation</a>
     */
    default RemovePermissionResponse removePermission(Consumer<RemovePermissionRequest.Builder> removePermissionRequest)
            throws InternalServerException, ConflictException, ValidationException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.
     * </p>
     *
     * @param submitFeedbackRequest
     *        The structure representing the SubmitFeedbackRequest.
     * @return Result of the SubmitFeedback operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.SubmitFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/SubmitFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitFeedbackResponse submitFeedback(SubmitFeedbackRequest submitFeedbackRequest) throws InternalServerException,
            ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link SubmitFeedbackRequest#builder()}
     * </p>
     *
     * @param submitFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link SubmitFeedbackRequest.Builder} to create a request.
     *        The structure representing the SubmitFeedbackRequest.
     * @return Result of the SubmitFeedback operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.SubmitFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/SubmitFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitFeedbackResponse submitFeedback(Consumer<SubmitFeedbackRequest.Builder> submitFeedbackRequest)
            throws InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, CodeGuruProfilerException {
        return submitFeedback(SubmitFeedbackRequest.builder().applyMutation(submitFeedbackRequest).build());
    }

    /**
     * <p>
     * Use to assign one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to assign one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Use to remove one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use to remove one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a profiling group.
     * </p>
     *
     * @param updateProfilingGroupRequest
     *        The structure representing the updateProfilingGroupRequest.
     * @return Result of the UpdateProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.UpdateProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfilingGroupResponse updateProfilingGroup(UpdateProfilingGroupRequest updateProfilingGroupRequest)
            throws InternalServerException, ConflictException, ValidationException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruProfilerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProfilingGroupRequest#builder()}
     * </p>
     *
     * @param updateProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfilingGroupRequest.Builder} to create a
     *        request. The structure representing the updateProfilingGroupRequest.
     * @return Result of the UpdateProfilingGroup operation returned by the service.
     * @throws InternalServerException
     *         The server encountered an internal error and is unable to complete the request.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The parameter is not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeGuruProfilerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeGuruProfilerClient.UpdateProfilingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfilingGroupResponse updateProfilingGroup(
            Consumer<UpdateProfilingGroupRequest.Builder> updateProfilingGroupRequest) throws InternalServerException,
            ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CodeGuruProfilerException {
        return updateProfilingGroup(UpdateProfilingGroupRequest.builder().applyMutation(updateProfilingGroupRequest).build());
    }

    /**
     * Create a {@link CodeGuruProfilerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeGuruProfilerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeGuruProfilerClient}.
     */
    static CodeGuruProfilerClientBuilder builder() {
        return new DefaultCodeGuruProfilerClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CodeGuruProfilerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
