/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the GetRecommendationsResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<GetRecommendationsResponse.Builder, GetRecommendationsResponse> {
    private static final SdkField<List<Anomaly>> ANOMALIES_FIELD = SdkField
            .<List<Anomaly>> builder(MarshallingType.LIST)
            .memberName("anomalies")
            .getter(getter(GetRecommendationsResponse::anomalies))
            .setter(setter(Builder::anomalies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Anomaly> builder(MarshallingType.SDK_POJO)
                                            .constructor(Anomaly::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> PROFILE_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("profileEndTime")
            .getter(getter(GetRecommendationsResponse::profileEndTime))
            .setter(setter(Builder::profileEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> PROFILE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("profileStartTime")
            .getter(getter(GetRecommendationsResponse::profileStartTime))
            .setter(setter(Builder::profileStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(GetRecommendationsResponse::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupName").build())
            .build();

    private static final SdkField<List<Recommendation>> RECOMMENDATIONS_FIELD = SdkField
            .<List<Recommendation>> builder(MarshallingType.LIST)
            .memberName("recommendations")
            .getter(getter(GetRecommendationsResponse::recommendations))
            .setter(setter(Builder::recommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Recommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Recommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALIES_FIELD,
            PROFILE_END_TIME_FIELD, PROFILE_START_TIME_FIELD, PROFILING_GROUP_NAME_FIELD, RECOMMENDATIONS_FIELD));

    private final List<Anomaly> anomalies;

    private final Instant profileEndTime;

    private final Instant profileStartTime;

    private final String profilingGroupName;

    private final List<Recommendation> recommendations;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalies = builder.anomalies;
        this.profileEndTime = builder.profileEndTime;
        this.profileStartTime = builder.profileStartTime;
        this.profilingGroupName = builder.profilingGroupName;
        this.recommendations = builder.recommendations;
    }

    /**
     * Returns true if the Anomalies property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAnomalies() {
        return anomalies != null && !(anomalies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of anomalies that the analysis has found for this profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAnomalies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of anomalies that the analysis has found for this profile.
     */
    public final List<Anomaly> anomalies() {
        return anomalies;
    }

    /**
     * <p>
     * The end time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The end time of the profile the analysis data is about. This is specified using the ISO 8601 format. For
     *         example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant profileEndTime() {
        return profileEndTime;
    }

    /**
     * <p>
     * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For
     * example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The start time of the profile the analysis data is about. This is specified using the ISO 8601 format.
     *         For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant profileStartTime() {
        return profileStartTime;
    }

    /**
     * <p>
     * The name of the profiling group the analysis data is about.
     * </p>
     * 
     * @return The name of the profiling group the analysis data is about.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * Returns true if the Recommendations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRecommendations() {
        return recommendations != null && !(recommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of recommendations that the analysis found for this profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecommendations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of recommendations that the analysis found for this profile.
     */
    public final List<Recommendation> recommendations() {
        return recommendations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnomalies() ? anomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(profileEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(profileStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendations() ? recommendations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse) obj;
        return hasAnomalies() == other.hasAnomalies() && Objects.equals(anomalies(), other.anomalies())
                && Objects.equals(profileEndTime(), other.profileEndTime())
                && Objects.equals(profileStartTime(), other.profileStartTime())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && hasRecommendations() == other.hasRecommendations()
                && Objects.equals(recommendations(), other.recommendations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationsResponse").add("Anomalies", hasAnomalies() ? anomalies() : null)
                .add("ProfileEndTime", profileEndTime()).add("ProfileStartTime", profileStartTime())
                .add("ProfilingGroupName", profilingGroupName())
                .add("Recommendations", hasRecommendations() ? recommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalies":
            return Optional.ofNullable(clazz.cast(anomalies()));
        case "profileEndTime":
            return Optional.ofNullable(clazz.cast(profileEndTime()));
        case "profileStartTime":
            return Optional.ofNullable(clazz.cast(profileStartTime()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "recommendations":
            return Optional.ofNullable(clazz.cast(recommendations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationsResponse> {
        /**
         * <p>
         * The list of anomalies that the analysis has found for this profile.
         * </p>
         * 
         * @param anomalies
         *        The list of anomalies that the analysis has found for this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalies(Collection<Anomaly> anomalies);

        /**
         * <p>
         * The list of anomalies that the analysis has found for this profile.
         * </p>
         * 
         * @param anomalies
         *        The list of anomalies that the analysis has found for this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalies(Anomaly... anomalies);

        /**
         * <p>
         * The list of anomalies that the analysis has found for this profile.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Anomaly>.Builder} avoiding the need to
         * create one manually via {@link List<Anomaly>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Anomaly>.Builder#build()} is called immediately and its
         * result is passed to {@link #anomalies(List<Anomaly>)}.
         * 
         * @param anomalies
         *        a consumer that will call methods on {@link List<Anomaly>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalies(List<Anomaly>)
         */
        Builder anomalies(Consumer<Anomaly.Builder>... anomalies);

        /**
         * <p>
         * The end time of the profile the analysis data is about. This is specified using the ISO 8601 format. For
         * example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param profileEndTime
         *        The end time of the profile the analysis data is about. This is specified using the ISO 8601 format.
         *        For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileEndTime(Instant profileEndTime);

        /**
         * <p>
         * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For
         * example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param profileStartTime
         *        The start time of the profile the analysis data is about. This is specified using the ISO 8601 format.
         *        For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileStartTime(Instant profileStartTime);

        /**
         * <p>
         * The name of the profiling group the analysis data is about.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group the analysis data is about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The list of recommendations that the analysis found for this profile.
         * </p>
         * 
         * @param recommendations
         *        The list of recommendations that the analysis found for this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(Collection<Recommendation> recommendations);

        /**
         * <p>
         * The list of recommendations that the analysis found for this profile.
         * </p>
         * 
         * @param recommendations
         *        The list of recommendations that the analysis found for this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendations(Recommendation... recommendations);

        /**
         * <p>
         * The list of recommendations that the analysis found for this profile.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Recommendation>.Builder} avoiding the need
         * to create one manually via {@link List<Recommendation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Recommendation>.Builder#build()} is called immediately and
         * its result is passed to {@link #recommendations(List<Recommendation>)}.
         * 
         * @param recommendations
         *        a consumer that will call methods on {@link List<Recommendation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendations(List<Recommendation>)
         */
        Builder recommendations(Consumer<Recommendation.Builder>... recommendations);
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private List<Anomaly> anomalies = DefaultSdkAutoConstructList.getInstance();

        private Instant profileEndTime;

        private Instant profileStartTime;

        private String profilingGroupName;

        private List<Recommendation> recommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            anomalies(model.anomalies);
            profileEndTime(model.profileEndTime);
            profileStartTime(model.profileStartTime);
            profilingGroupName(model.profilingGroupName);
            recommendations(model.recommendations);
        }

        public final Collection<Anomaly.Builder> getAnomalies() {
            if (anomalies instanceof SdkAutoConstructList) {
                return null;
            }
            return anomalies != null ? anomalies.stream().map(Anomaly::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder anomalies(Collection<Anomaly> anomalies) {
            this.anomalies = AnomaliesCopier.copy(anomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalies(Anomaly... anomalies) {
            anomalies(Arrays.asList(anomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalies(Consumer<Anomaly.Builder>... anomalies) {
            anomalies(Stream.of(anomalies).map(c -> Anomaly.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalies(Collection<Anomaly.BuilderImpl> anomalies) {
            this.anomalies = AnomaliesCopier.copyFromBuilder(anomalies);
        }

        public final Instant getProfileEndTime() {
            return profileEndTime;
        }

        @Override
        public final Builder profileEndTime(Instant profileEndTime) {
            this.profileEndTime = profileEndTime;
            return this;
        }

        public final void setProfileEndTime(Instant profileEndTime) {
            this.profileEndTime = profileEndTime;
        }

        public final Instant getProfileStartTime() {
            return profileStartTime;
        }

        @Override
        public final Builder profileStartTime(Instant profileStartTime) {
            this.profileStartTime = profileStartTime;
            return this;
        }

        public final void setProfileStartTime(Instant profileStartTime) {
            this.profileStartTime = profileStartTime;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        public final Collection<Recommendation.Builder> getRecommendations() {
            if (recommendations instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendations != null ? recommendations.stream().map(Recommendation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder recommendations(Collection<Recommendation> recommendations) {
            this.recommendations = RecommendationsCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Recommendation... recommendations) {
            recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<Recommendation.Builder>... recommendations) {
            recommendations(Stream.of(recommendations).map(c -> Recommendation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendations(Collection<Recommendation.BuilderImpl> recommendations) {
            this.recommendations = RecommendationsCopier.copyFromBuilder(recommendations);
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
