/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class AgentParametersCopier {
    static Map<String, String> copy(Map<String, String> agentParametersParam) {
        if (agentParametersParam == null || agentParametersParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, String> agentParametersParamCopy = agentParametersParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
        return Collections.unmodifiableMap(agentParametersParamCopy);
    }

    static Map<String, String> copyEnumToString(Map<AgentParameterField, String> agentParametersParam) {
        if (agentParametersParam == null || agentParametersParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, String> agentParametersParamCopy = agentParametersParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey().toString(), e.getValue()), HashMap::putAll);
        return Collections.unmodifiableMap(agentParametersParamCopy);
    }

    static Map<AgentParameterField, String> copyStringToEnum(Map<String, String> agentParametersParam) {
        if (agentParametersParam == null || agentParametersParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<AgentParameterField, String> agentParametersParamCopy = agentParametersParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> {
                    AgentParameterField keyAsEnum = AgentParameterField.fromValue(e.getKey());
                    if (keyAsEnum != AgentParameterField.UNKNOWN_TO_SDK_VERSION) {
                        m.put(keyAsEnum, e.getValue());
                    }
                }, HashMap::putAll);
        return Collections.unmodifiableMap(agentParametersParamCopy);
    }
}
