/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetric;
import software.amazon.awssdk.services.codeguruprofiler.model.FrameMetricValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameMetricDatum
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameMetricDatum> {
    private static final SdkField<FrameMetric> FRAME_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FrameMetricDatum.getter(FrameMetricDatum::frameMetric)).setter(FrameMetricDatum.setter(Builder::frameMetric)).constructor(FrameMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameMetric").build()}).build();
    private static final SdkField<List<Double>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FrameMetricDatum.getter(FrameMetricDatum::values)).setter(FrameMetricDatum.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_METRIC_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final FrameMetric frameMetric;
    private final List<Double> values;

    private FrameMetricDatum(BuilderImpl builder) {
        this.frameMetric = builder.frameMetric;
        this.values = builder.values;
    }

    public FrameMetric frameMetric() {
        return this.frameMetric;
    }

    public boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public List<Double> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameMetricDatum)) {
            return false;
        }
        FrameMetricDatum other = (FrameMetricDatum)obj;
        return Objects.equals(this.frameMetric(), other.frameMetric()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"FrameMetricDatum").add("FrameMetric", (Object)this.frameMetric()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frameMetric": {
                return Optional.ofNullable(clazz.cast(this.frameMetric()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameMetricDatum, T> g) {
        return obj -> g.apply((FrameMetricDatum)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FrameMetric frameMetric;
        private List<Double> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FrameMetricDatum model) {
            this.frameMetric(model.frameMetric);
            this.values(model.values);
        }

        public final FrameMetric.Builder getFrameMetric() {
            return this.frameMetric != null ? this.frameMetric.toBuilder() : null;
        }

        @Override
        public final Builder frameMetric(FrameMetric frameMetric) {
            this.frameMetric = frameMetric;
            return this;
        }

        public final void setFrameMetric(FrameMetric.BuilderImpl frameMetric) {
            this.frameMetric = frameMetric != null ? frameMetric.build() : null;
        }

        public final Collection<Double> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = FrameMetricValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<Double> values) {
            this.values = FrameMetricValuesCopier.copy(values);
        }

        public FrameMetricDatum build() {
            return new FrameMetricDatum(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameMetricDatum> {
        public Builder frameMetric(FrameMetric var1);

        default public Builder frameMetric(Consumer<FrameMetric.Builder> frameMetric) {
            return this.frameMetric((FrameMetric)((FrameMetric.Builder)FrameMetric.builder().applyMutation(frameMetric)).build());
        }

        public Builder values(Collection<Double> var1);

        public Builder values(Double ... var1);
    }
}

