/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the putPermissionRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPermissionRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<PutPermissionRequest.Builder, PutPermissionRequest> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutPermissionRequest::actionGroupAsString)).setter(setter(Builder::actionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("actionGroup").build()).build();

    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutPermissionRequest::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutPermissionRequest::profilingGroupName)).setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutPermissionRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD,
            PRINCIPALS_FIELD, PROFILING_GROUP_NAME_FIELD, REVISION_ID_FIELD));

    private final String actionGroup;

    private final List<String> principals;

    private final String profilingGroupName;

    private final String revisionId;

    private PutPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.actionGroup = builder.actionGroup;
        this.principals = builder.principals;
        this.profilingGroupName = builder.profilingGroupName;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The list of actions that the users and roles can perform on the profiling group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroup} will
     * return {@link ActionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionGroupAsString}.
     * </p>
     * 
     * @return The list of actions that the users and roles can perform on the profiling group.
     * @see ActionGroup
     */
    public ActionGroup actionGroup() {
        return ActionGroup.fromValue(actionGroup);
    }

    /**
     * <p>
     * The list of actions that the users and roles can perform on the profiling group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroup} will
     * return {@link ActionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionGroupAsString}.
     * </p>
     * 
     * @return The list of actions that the users and roles can perform on the profiling group.
     * @see ActionGroup
     */
    public String actionGroupAsString() {
        return actionGroup;
    }

    /**
     * Returns true if the Principals property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of role and user ARNs or the accountId that needs access (wildcards are not allowed).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of role and user ARNs or the accountId that needs access (wildcards are not allowed).
     */
    public List<String> principals() {
        return principals;
    }

    /**
     * <p>
     * The name of the profiling group.
     * </p>
     * 
     * @return The name of the profiling group.
     */
    public String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * A unique identifier for the current revision of the policy. This is required, if a policy exists for the
     * profiling group. This is not required when creating the policy for the first time.
     * </p>
     * 
     * @return A unique identifier for the current revision of the policy. This is required, if a policy exists for the
     *         profiling group. This is not required when creating the policy for the first time.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principals());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPermissionRequest)) {
            return false;
        }
        PutPermissionRequest other = (PutPermissionRequest) obj;
        return Objects.equals(actionGroupAsString(), other.actionGroupAsString())
                && Objects.equals(principals(), other.principals())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPermissionRequest").add("ActionGroup", actionGroupAsString()).add("Principals", principals())
                .add("ProfilingGroupName", profilingGroupName()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroup":
            return Optional.ofNullable(clazz.cast(actionGroupAsString()));
        case "principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPermissionRequest, T> g) {
        return obj -> g.apply((PutPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPermissionRequest> {
        /**
         * <p>
         * The list of actions that the users and roles can perform on the profiling group.
         * </p>
         * 
         * @param actionGroup
         *        The list of actions that the users and roles can perform on the profiling group.
         * @see ActionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroup
         */
        Builder actionGroup(String actionGroup);

        /**
         * <p>
         * The list of actions that the users and roles can perform on the profiling group.
         * </p>
         * 
         * @param actionGroup
         *        The list of actions that the users and roles can perform on the profiling group.
         * @see ActionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroup
         */
        Builder actionGroup(ActionGroup actionGroup);

        /**
         * <p>
         * The list of role and user ARNs or the accountId that needs access (wildcards are not allowed).
         * </p>
         * 
         * @param principals
         *        The list of role and user ARNs or the accountId that needs access (wildcards are not allowed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * The list of role and user ARNs or the accountId that needs access (wildcards are not allowed).
         * </p>
         * 
         * @param principals
         *        The list of role and user ARNs or the accountId that needs access (wildcards are not allowed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);

        /**
         * <p>
         * The name of the profiling group.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * A unique identifier for the current revision of the policy. This is required, if a policy exists for the
         * profiling group. This is not required when creating the policy for the first time.
         * </p>
         * 
         * @param revisionId
         *        A unique identifier for the current revision of the policy. This is required, if a policy exists for
         *        the profiling group. This is not required when creating the policy for the first time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private String actionGroup;

        private List<String> principals = DefaultSdkAutoConstructList.getInstance();

        private String profilingGroupName;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPermissionRequest model) {
            super(model);
            actionGroup(model.actionGroup);
            principals(model.principals);
            profilingGroupName(model.profilingGroupName);
            revisionId(model.revisionId);
        }

        public final String getActionGroup() {
            return actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        @Override
        public final Builder actionGroup(ActionGroup actionGroup) {
            this.actionGroup(actionGroup == null ? null : actionGroup.toString());
            return this;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        public final Collection<String> getPrincipals() {
            return principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPermissionRequest build() {
            return new PutPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
