/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the configureAgentResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureAgentResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<ConfigureAgentResponse.Builder, ConfigureAgentResponse> {
    private static final SdkField<AgentConfiguration> CONFIGURATION_FIELD = SdkField
            .<AgentConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ConfigureAgentResponse::configuration))
            .setter(setter(Builder::configuration))
            .constructor(AgentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private final AgentConfiguration configuration;

    private ConfigureAgentResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public AgentConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureAgentResponse)) {
            return false;
        }
        ConfigureAgentResponse other = (ConfigureAgentResponse) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigureAgentResponse").add("Configuration", configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureAgentResponse, T> g) {
        return obj -> g.apply((ConfigureAgentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ConfigureAgentResponse> {
        /**
         * <p/>
         * 
         * @param configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AgentConfiguration configuration);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link AgentConfiguration.Builder} avoiding the need to
         * create one manually via {@link AgentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgentConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(AgentConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AgentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AgentConfiguration)
         */
        default Builder configuration(Consumer<AgentConfiguration.Builder> configuration) {
            return configuration(AgentConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private AgentConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureAgentResponse model) {
            super(model);
            configuration(model.configuration);
        }

        public final AgentConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(AgentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(AgentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public ConfigureAgentResponse build() {
            return new ConfigureAgentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
