/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse;

public class ListProfilingGroupsIterable
implements SdkIterable<ListProfilingGroupsResponse> {
    private final CodeGuruProfilerClient client;
    private final ListProfilingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfilingGroupsIterable(CodeGuruProfilerClient client, ListProfilingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProfilingGroupsResponseFetcher();
    }

    public Iterator<ListProfilingGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProfilingGroupsResponseFetcher
    implements SyncPageFetcher<ListProfilingGroupsResponse> {
        private ListProfilingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfilingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfilingGroupsResponse nextPage(ListProfilingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListProfilingGroupsIterable.this.client.listProfilingGroups(ListProfilingGroupsIterable.this.firstRequest);
            }
            return ListProfilingGroupsIterable.this.client.listProfilingGroups((ListProfilingGroupsRequest)((Object)ListProfilingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

