/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request for UpdateProfilingGroup operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfilingGroupRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<UpdateProfilingGroupRequest.Builder, UpdateProfilingGroupRequest> {
    private static final SdkField<AgentOrchestrationConfig> AGENT_ORCHESTRATION_CONFIG_FIELD = SdkField
            .<AgentOrchestrationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateProfilingGroupRequest::agentOrchestrationConfig))
            .setter(setter(Builder::agentOrchestrationConfig)).constructor(AgentOrchestrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentOrchestrationConfig").build())
            .build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProfilingGroupRequest::profilingGroupName)).setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGENT_ORCHESTRATION_CONFIG_FIELD, PROFILING_GROUP_NAME_FIELD));

    private final AgentOrchestrationConfig agentOrchestrationConfig;

    private final String profilingGroupName;

    private UpdateProfilingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.agentOrchestrationConfig = builder.agentOrchestrationConfig;
        this.profilingGroupName = builder.profilingGroupName;
    }

    /**
     * <p>
     * Remote configuration to configure the agents of the profiling group.
     * </p>
     * 
     * @return Remote configuration to configure the agents of the profiling group.
     */
    public AgentOrchestrationConfig agentOrchestrationConfig() {
        return agentOrchestrationConfig;
    }

    /**
     * Returns the value of the ProfilingGroupName property for this object.
     * 
     * @return The value of the ProfilingGroupName property for this object.
     */
    public String profilingGroupName() {
        return profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentOrchestrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfilingGroupRequest)) {
            return false;
        }
        UpdateProfilingGroupRequest other = (UpdateProfilingGroupRequest) obj;
        return Objects.equals(agentOrchestrationConfig(), other.agentOrchestrationConfig())
                && Objects.equals(profilingGroupName(), other.profilingGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateProfilingGroupRequest").add("AgentOrchestrationConfig", agentOrchestrationConfig())
                .add("ProfilingGroupName", profilingGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentOrchestrationConfig":
            return Optional.ofNullable(clazz.cast(agentOrchestrationConfig()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfilingGroupRequest, T> g) {
        return obj -> g.apply((UpdateProfilingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProfilingGroupRequest> {
        /**
         * <p>
         * Remote configuration to configure the agents of the profiling group.
         * </p>
         * 
         * @param agentOrchestrationConfig
         *        Remote configuration to configure the agents of the profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig);

        /**
         * <p>
         * Remote configuration to configure the agents of the profiling group.
         * </p>
         * This is a convenience that creates an instance of the {@link AgentOrchestrationConfig.Builder} avoiding the
         * need to create one manually via {@link AgentOrchestrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgentOrchestrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #agentOrchestrationConfig(AgentOrchestrationConfig)}.
         * 
         * @param agentOrchestrationConfig
         *        a consumer that will call methods on {@link AgentOrchestrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentOrchestrationConfig(AgentOrchestrationConfig)
         */
        default Builder agentOrchestrationConfig(Consumer<AgentOrchestrationConfig.Builder> agentOrchestrationConfig) {
            return agentOrchestrationConfig(AgentOrchestrationConfig.builder().applyMutation(agentOrchestrationConfig).build());
        }

        /**
         * Sets the value of the ProfilingGroupName property for this object.
         *
         * @param profilingGroupName
         *        The new value for the ProfilingGroupName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private AgentOrchestrationConfig agentOrchestrationConfig;

        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfilingGroupRequest model) {
            super(model);
            agentOrchestrationConfig(model.agentOrchestrationConfig);
            profilingGroupName(model.profilingGroupName);
        }

        public final AgentOrchestrationConfig.Builder getAgentOrchestrationConfig() {
            return agentOrchestrationConfig != null ? agentOrchestrationConfig.toBuilder() : null;
        }

        @Override
        public final Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig;
            return this;
        }

        public final void setAgentOrchestrationConfig(AgentOrchestrationConfig.BuilderImpl agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig != null ? agentOrchestrationConfig.build() : null;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfilingGroupRequest build() {
            return new UpdateProfilingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
