/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of a profiling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfilingGroupDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfilingGroupDescription.Builder, ProfilingGroupDescription> {
    private static final SdkField<AgentOrchestrationConfig> AGENT_ORCHESTRATION_CONFIG_FIELD = SdkField
            .<AgentOrchestrationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(ProfilingGroupDescription::agentOrchestrationConfig))
            .setter(setter(Builder::agentOrchestrationConfig)).constructor(AgentOrchestrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentOrchestrationConfig").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfilingGroupDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProfilingGroupDescription::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfilingGroupDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ProfilingStatus> PROFILING_STATUS_FIELD = SdkField
            .<ProfilingStatus> builder(MarshallingType.SDK_POJO).getter(getter(ProfilingGroupDescription::profilingStatus))
            .setter(setter(Builder::profilingStatus)).constructor(ProfilingStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingStatus").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProfilingGroupDescription::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGENT_ORCHESTRATION_CONFIG_FIELD, ARN_FIELD, CREATED_AT_FIELD, NAME_FIELD, PROFILING_STATUS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final AgentOrchestrationConfig agentOrchestrationConfig;

    private final String arn;

    private final Instant createdAt;

    private final String name;

    private final ProfilingStatus profilingStatus;

    private final Instant updatedAt;

    private ProfilingGroupDescription(BuilderImpl builder) {
        this.agentOrchestrationConfig = builder.agentOrchestrationConfig;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.name = builder.name;
        this.profilingStatus = builder.profilingStatus;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * Returns the value of the AgentOrchestrationConfig property for this object.
     * 
     * @return The value of the AgentOrchestrationConfig property for this object.
     */
    public AgentOrchestrationConfig agentOrchestrationConfig() {
        return agentOrchestrationConfig;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The timestamp of when the profiling group was created.
     * </p>
     * 
     * @return The timestamp of when the profiling group was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public String name() {
        return name;
    }

    /**
     * Returns the value of the ProfilingStatus property for this object.
     * 
     * @return The value of the ProfilingStatus property for this object.
     */
    public ProfilingStatus profilingStatus() {
        return profilingStatus;
    }

    /**
     * <p>
     * The timestamp of when the profiling group was last updated.
     * </p>
     * 
     * @return The timestamp of when the profiling group was last updated.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentOrchestrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(profilingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfilingGroupDescription)) {
            return false;
        }
        ProfilingGroupDescription other = (ProfilingGroupDescription) obj;
        return Objects.equals(agentOrchestrationConfig(), other.agentOrchestrationConfig()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(name(), other.name())
                && Objects.equals(profilingStatus(), other.profilingStatus()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProfilingGroupDescription").add("AgentOrchestrationConfig", agentOrchestrationConfig())
                .add("Arn", arn()).add("CreatedAt", createdAt()).add("Name", name()).add("ProfilingStatus", profilingStatus())
                .add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentOrchestrationConfig":
            return Optional.ofNullable(clazz.cast(agentOrchestrationConfig()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "profilingStatus":
            return Optional.ofNullable(clazz.cast(profilingStatus()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfilingGroupDescription, T> g) {
        return obj -> g.apply((ProfilingGroupDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfilingGroupDescription> {
        /**
         * Sets the value of the AgentOrchestrationConfig property for this object.
         *
         * @param agentOrchestrationConfig
         *        The new value for the AgentOrchestrationConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig);

        /**
         * Sets the value of the AgentOrchestrationConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link AgentOrchestrationConfig.Builder} avoiding the
         * need to create one manually via {@link AgentOrchestrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AgentOrchestrationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #agentOrchestrationConfig(AgentOrchestrationConfig)}.
         * 
         * @param agentOrchestrationConfig
         *        a consumer that will call methods on {@link AgentOrchestrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentOrchestrationConfig(AgentOrchestrationConfig)
         */
        default Builder agentOrchestrationConfig(Consumer<AgentOrchestrationConfig.Builder> agentOrchestrationConfig) {
            return agentOrchestrationConfig(AgentOrchestrationConfig.builder().applyMutation(agentOrchestrationConfig).build());
        }

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The timestamp of when the profiling group was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the profiling group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the ProfilingStatus property for this object.
         *
         * @param profilingStatus
         *        The new value for the ProfilingStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingStatus(ProfilingStatus profilingStatus);

        /**
         * Sets the value of the ProfilingStatus property for this object.
         *
         * This is a convenience that creates an instance of the {@link ProfilingStatus.Builder} avoiding the need to
         * create one manually via {@link ProfilingStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProfilingStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #profilingStatus(ProfilingStatus)}.
         * 
         * @param profilingStatus
         *        a consumer that will call methods on {@link ProfilingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profilingStatus(ProfilingStatus)
         */
        default Builder profilingStatus(Consumer<ProfilingStatus.Builder> profilingStatus) {
            return profilingStatus(ProfilingStatus.builder().applyMutation(profilingStatus).build());
        }

        /**
         * <p>
         * The timestamp of when the profiling group was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the profiling group was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private AgentOrchestrationConfig agentOrchestrationConfig;

        private String arn;

        private Instant createdAt;

        private String name;

        private ProfilingStatus profilingStatus;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfilingGroupDescription model) {
            agentOrchestrationConfig(model.agentOrchestrationConfig);
            arn(model.arn);
            createdAt(model.createdAt);
            name(model.name);
            profilingStatus(model.profilingStatus);
            updatedAt(model.updatedAt);
        }

        public final AgentOrchestrationConfig.Builder getAgentOrchestrationConfig() {
            return agentOrchestrationConfig != null ? agentOrchestrationConfig.toBuilder() : null;
        }

        @Override
        public final Builder agentOrchestrationConfig(AgentOrchestrationConfig agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig;
            return this;
        }

        public final void setAgentOrchestrationConfig(AgentOrchestrationConfig.BuilderImpl agentOrchestrationConfig) {
            this.agentOrchestrationConfig = agentOrchestrationConfig != null ? agentOrchestrationConfig.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ProfilingStatus.Builder getProfilingStatus() {
            return profilingStatus != null ? profilingStatus.toBuilder() : null;
        }

        @Override
        public final Builder profilingStatus(ProfilingStatus profilingStatus) {
            this.profilingStatus = profilingStatus;
            return this;
        }

        public final void setProfilingStatus(ProfilingStatus.BuilderImpl profilingStatus) {
            this.profilingStatus = profilingStatus != null ? profilingStatus.build() : null;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public ProfilingGroupDescription build() {
            return new ProfilingGroupDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
