/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.common;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;

public final class EnumClass
implements ClassSpec {
    private static final String VALUE = "value";
    private static final String UNKNOWN_TO_SDK_VERSION = "UNKNOWN_TO_SDK_VERSION";
    private final ShapeModel shape;
    private final ClassName className;

    public EnumClass(String enumPackage, ShapeModel shape) {
        this.shape = shape;
        this.className = ClassName.get((String)enumPackage, (String)shape.getShapeName(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder enumBuilder = PoetUtils.createEnumBuilder(this.className).addField(String.class, VALUE, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(PoetUtils.toStringBuilder().addStatement("return $T.valueOf($N)", new Object[]{String.class, VALUE}).build()).addMethod(this.fromValueSpec()).addMethod(this.knownValuesSpec()).addMethod(this.createConstructor());
        PoetUtils.addDeprecated(arg_0 -> ((TypeSpec.Builder)enumBuilder).addAnnotation(arg_0), this.shape);
        PoetUtils.addJavadoc(x$0 -> enumBuilder.addJavadoc(x$0, new Object[0]), this.shape);
        this.shape.getEnums().forEach(e -> enumBuilder.addEnumConstant(e.getName(), TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{e.getValue()}).build()));
        enumBuilder.addEnumConstant(UNKNOWN_TO_SDK_VERSION, TypeSpec.anonymousClassBuilder((String)"null", (Object[])new Object[0]).build());
        return enumBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        return Collections.singleton(StaticImport.staticMethodImport(Collectors.class, "toSet"));
    }

    private MethodSpec createConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, VALUE, new Modifier[0]).addStatement("this.$1N = $1N", new Object[]{VALUE}).build();
    }

    private MethodSpec fromValueSpec() {
        return MethodSpec.methodBuilder((String)"fromValue").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Use this in place of valueOf to convert the raw string returned by the service into the enum value.\n\n@param $N real value\n@return $T corresponding to the value\n", new Object[]{VALUE, this.className}).addParameter(String.class, VALUE, new Modifier[0]).beginControlFlow("if ($N == null)", new Object[]{VALUE}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $1T.of($2T.values())\n.filter(e -> e.toString().equals($3N))\n.findFirst()\n.orElse(UNKNOWN_TO_SDK_VERSION)", new Object[]{Stream.class, this.className, VALUE}).build();
    }

    private MethodSpec knownValuesSpec() {
        return MethodSpec.methodBuilder((String)"knownValues").returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{this.className})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK.\nThis will return all known enum values except {@link #$N}.\n\n@return a {@link $T} of known {@link $T}s", new Object[]{UNKNOWN_TO_SDK_VERSION, Set.class, this.className}).addStatement("return $T.of(values()).filter(v -> v != $N).collect(toSet())", new Object[]{Stream.class, UNKNOWN_TO_SDK_VERSION}).build();
    }
}

