/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.utils.NamingUtils;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;

public class ResponseMetadataSpec
implements ClassSpec {
    private PoetExtensions poetExtensions;
    private Map<String, String> headerMetadata = new HashMap<String, String>();

    public ResponseMetadataSpec(IntermediateModel model) {
        if (!CollectionUtils.isNullOrEmpty(model.getCustomizationConfig().getCustomResponseMetadata())) {
            this.headerMetadata.putAll(model.getCustomizationConfig().getCustomResponseMetadata());
        }
        this.poetExtensions = new PoetExtensions(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(PoetUtils.generatedAnnotation()).addAnnotation(SdkPublicApi.class).superclass(AwsResponseMetadata.class).addMethod(this.constructor()).addMethod(this.staticFactoryMethod()).addMethods(this.metadataMethods());
        List fields = this.headerMetadata.entrySet().stream().map(e -> FieldSpec.builder(String.class, (String)((String)e.getKey()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{e.getValue()}).build()).collect(Collectors.toList());
        specBuilder.addFields(fields);
        return specBuilder.build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(AwsResponseMetadata.class, "responseMetadata", new Modifier[0]).addStatement("super(responseMetadata)", new Object[0]).build();
    }

    private MethodSpec staticFactoryMethod() {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(AwsResponseMetadata.class, "responseMetadata", new Modifier[0]).addStatement("return new $T(responseMetadata)", new Object[]{this.className()}).returns((TypeName)this.className()).build();
    }

    private List<MethodSpec> metadataMethods() {
        return this.headerMetadata.keySet().stream().map(key -> {
            String methodName = this.convertMethodName((String)key);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return getValue($L)", new Object[]{key}).returns(String.class);
            if (methodName.equals("requestId")) {
                methodBuilder.addAnnotation(Override.class);
            }
            return methodBuilder.build();
        }).collect(Collectors.toList());
    }

    private String convertMethodName(String key) {
        String pascalCase = NamingUtils.pascalCase(key);
        return StringUtils.uncapitalize((String)pascalCase);
    }

    @Override
    public ClassName className() {
        return this.poetExtensions.getResponseMetadataClass();
    }
}

