/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.endpointdiscovery.providers.DefaultEndpointDiscoveryProviderChain;
import software.amazon.awssdk.core.endpointdiscovery.providers.EndpointDiscoveryProviderChain;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;

public class BaseClientBuilderClass
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final String basePackage;

    public BaseClientBuilderClass(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(SdkInternalApi.class).addTypeVariable(PoetUtils.createBoundedTypeVariableName("B", this.builderInterfaceName, "B", "C")).addTypeVariable(TypeVariableName.get((String)"C")).superclass((TypeName)PoetUtils.createParameterizedTypeName(AwsDefaultClientBuilder.class, "B", "C")).addJavadoc("Internal base class for {@link $T} and {@link $T}.", new Object[]{ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0])});
        if (this.model.getEndpointOperation().isPresent()) {
            builder.addField(FieldSpec.builder(EndpointDiscoveryProviderChain.class, (String)"CHAIN", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{DefaultEndpointDiscoveryProviderChain.class}).build());
            builder.addField(FieldSpec.builder(Boolean.TYPE, (String)"endpointDiscoveryEnabled", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED}).initializer("false", new Object[0]).build());
        }
        builder.addMethod(this.serviceEndpointPrefixMethod());
        builder.addMethod(this.serviceNameMethod());
        builder.addMethod(this.mergeServiceDefaultsMethod());
        builder.addMethod(this.finalizeServiceConfigurationMethod());
        builder.addMethod(this.defaultSignerMethod());
        builder.addMethod(this.signingNameMethod());
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            builder.addMethod(this.setServiceConfigurationMethod()).addMethod(this.beanStyleSetServiceConfigurationMethod());
        }
        this.addServiceHttpConfigIfNeeded(builder, this.model);
        return builder.build();
    }

    private MethodSpec signingNameMethod() {
        return MethodSpec.methodBuilder((String)"signingName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getSigningName()}).build();
    }

    private MethodSpec defaultSignerMethod() {
        return MethodSpec.methodBuilder((String)"defaultSigner").returns(Signer.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode(this.signerDefinitionMethodBody()).build();
    }

    private MethodSpec serviceEndpointPrefixMethod() {
        return MethodSpec.methodBuilder((String)"serviceEndpointPrefix").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getEndpointPrefix()}).build();
    }

    private MethodSpec serviceNameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getServiceName()}).build();
    }

    private MethodSpec mergeServiceDefaultsMethod() {
        boolean crc32FromCompressedDataEnabled = this.model.getCustomizationConfig().isCalculateCrc32FromCompressedData();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"mergeServiceDefaults").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("return config.merge(c -> c.option($T.SIGNER, defaultSigner())\n", new Object[]{SdkAdvancedClientOption.class}).addCode("                          .option($T.CRC32_FROM_COMPRESSED_DATA_ENABLED, $L)", new Object[]{SdkClientOption.class, crc32FromCompressedDataEnabled});
        if (StringUtils.isNotBlank((CharSequence)this.model.getCustomizationConfig().getCustomRetryPolicy())) {
            builder.addCode(".option($T.RETRY_POLICY, $T.defaultPolicy())", new Object[]{SdkClientOption.class, PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getCustomRetryPolicy())});
        }
        builder.addCode(");", new Object[0]);
        return builder.build();
    }

    private MethodSpec finalizeServiceConfigurationMethod() {
        String requestHandlerDirectory = Utils.packageToDirectory(this.model.getMetadata().getFullClientPackageName());
        String requestHandlerPath = String.format("%s/execution.interceptors", requestHandlerDirectory);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"finalizeServiceConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("$1T interceptorFactory = new $1T();\n", new Object[]{ClasspathInterceptorChainFactory.class}).addCode("$T<$T> interceptors = interceptorFactory.getInterceptors($S);\n", new Object[]{List.class, ExecutionInterceptor.class, requestHandlerPath}).addCode("interceptors = $T.mergeLists(interceptors, config.option($T.EXECUTION_INTERCEPTORS));\n", new Object[]{CollectionUtils.class, SdkClientOption.class});
        if (this.model.getEndpointOperation().isPresent()) {
            builder.beginControlFlow("if (!endpointDiscoveryEnabled)", new Object[0]).addStatement("endpointDiscoveryEnabled = CHAIN.resolveEndpointDiscovery()", new Object[0]).endControlFlow();
            builder.addCode("return config.toBuilder()\n       .option($1T.EXECUTION_INTERCEPTORS, interceptors)\n       .option($1T.ENDPOINT_DISCOVERY_ENABLED, endpointDiscoveryEnabled)\n       .build();", new Object[]{SdkClientOption.class});
        } else {
            builder.addCode("return config.toBuilder()\n       .option($T.EXECUTION_INTERCEPTORS, interceptors)\n       .build();", new Object[]{SdkClientOption.class});
        }
        return builder.build();
    }

    private MethodSpec setServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("clientConfiguration.option($T.SERVICE_CONFIGURATION, serviceConfiguration)", new Object[]{SdkClientOption.class}).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec beanStyleSetServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"setServiceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("serviceConfiguration(serviceConfiguration)", new Object[0]).build();
    }

    private void addServiceHttpConfigIfNeeded(TypeSpec.Builder builder, IntermediateModel model) {
        String serviceDefaultFqcn = model.getCustomizationConfig().getServiceSpecificHttpConfig();
        boolean supportsH2 = model.getMetadata().supportsH2();
        if (serviceDefaultFqcn != null || supportsH2) {
            builder.addMethod(this.serviceSpecificHttpConfigMethod(serviceDefaultFqcn, supportsH2));
        }
    }

    private MethodSpec serviceSpecificHttpConfigMethod(String serviceDefaultFqcn, boolean supportsH2) {
        return MethodSpec.methodBuilder((String)"serviceHttpConfig").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(AttributeMap.class).addCode(this.serviceSpecificHttpConfigMethodBody(serviceDefaultFqcn, supportsH2)).build();
    }

    private CodeBlock serviceSpecificHttpConfigMethodBody(String serviceDefaultFqcn, boolean supportsH2) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (serviceDefaultFqcn != null) {
            builder.addStatement("$T result = $T.defaultHttpConfig()", new Object[]{AttributeMap.class, PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getServiceSpecificHttpConfig())});
        } else {
            builder.addStatement("$1T result = $1T.empty()", new Object[]{AttributeMap.class});
        }
        if (supportsH2) {
            builder.addStatement("return result.merge(AttributeMap.builder().put($T.PROTOCOL, $T.HTTP2).build())", new Object[]{SdkHttpConfigurationOption.class, Protocol.class});
        } else {
            builder.addStatement("return result", new Object[0]);
        }
        return builder.build();
    }

    private CodeBlock signerDefinitionMethodBody() {
        AuthType authType = this.model.getMetadata().getAuthType();
        switch (authType) {
            case V4: {
                return this.v4SignerDefinitionMethodBody();
            }
            case S3: 
            case S3V4: {
                return this.s3SignerDefinitionMethodBody();
            }
        }
        throw new UnsupportedOperationException("Unsupported signer type: " + (Object)((Object)authType));
    }

    private CodeBlock v4SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();", (Object[])new Object[]{Aws4Signer.class});
    }

    private CodeBlock s3SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();\n", (Object[])new Object[]{ClassName.get((String)"software.amazon.awssdk.auth.signer", (String)"AwsS3V4Signer", (String[])new String[0])});
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }
}

