/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform.protocols;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.transform.protocols.MarshallerProtocolSpec;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.utils.StringUtils;

public class JsonMarshallerSpec
implements MarshallerProtocolSpec {
    protected final ShapeModel shapeModel;

    public JsonMarshallerSpec(ShapeModel shapeModel) {
        this.shapeModel = shapeModel;
    }

    @Override
    public ParameterSpec protocolFactoryParameter() {
        return ParameterSpec.builder(this.protocolFactoryClass(), (String)"protocolFactory", (Modifier[])new Modifier[0]).build();
    }

    @Override
    public Optional<MethodSpec> constructor() {
        return Optional.of(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.protocolFactoryParameter()).addStatement("this.protocolFactory = protocolFactory", new Object[0]).build());
    }

    @Override
    public CodeBlock marshalCodeBlock(ClassName requestClassName) {
        String variableName = this.shapeModel.getVariable().getVariableName();
        return CodeBlock.builder().addStatement("$T<$T> protocolMarshaller = protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING)", new Object[]{ProtocolMarshaller.class, SdkHttpFullRequest.class}).addStatement("return protocolMarshaller.marshall($L)", new Object[]{variableName}).build();
    }

    @Override
    public FieldSpec protocolFactory() {
        return FieldSpec.builder(this.protocolFactoryClass(), (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private Class<BaseAwsJsonProtocolFactory> protocolFactoryClass() {
        return BaseAwsJsonProtocolFactory.class;
    }

    @Override
    public List<FieldSpec> memberVariables() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        fields.add(this.operationInfoField());
        fields.add(this.protocolFactory());
        return fields;
    }

    protected FieldSpec operationInfoField() {
        CodeBlock.Builder initializationCodeBlockBuilder = CodeBlock.builder().add("$T.builder()", new Object[]{OperationInfo.class});
        initializationCodeBlockBuilder.add(".requestUri($S)", new Object[]{this.shapeModel.getMarshaller().getRequestUri()}).add(".httpMethod($T.$L)", new Object[]{SdkHttpMethod.class, this.shapeModel.getMarshaller().getVerb()}).add(".hasExplicitPayloadMember($L)", new Object[]{this.shapeModel.isHasPayloadMember() || this.shapeModel.getExplicitEventPayloadMember() != null}).add(".hasPayloadMembers($L)", new Object[]{this.shapeModel.hasPayloadMembers()});
        if (StringUtils.isNotBlank((CharSequence)this.shapeModel.getMarshaller().getTarget())) {
            initializationCodeBlockBuilder.add(".operationIdentifier($S)", new Object[]{this.shapeModel.getMarshaller().getTarget()});
        }
        if (this.shapeModel.isHasStreamingMember()) {
            initializationCodeBlockBuilder.add(".hasStreamingInput(true)", new Object[0]);
        }
        if (EventStreamUtils.isEventStreamParentModel(this.shapeModel)) {
            initializationCodeBlockBuilder.add(".hasEventStreamingInput(true)", new Object[0]);
        }
        CodeBlock codeBlock = initializationCodeBlockBuilder.add(".build()", new Object[0]).build();
        return FieldSpec.builder((TypeName)ClassName.get(OperationInfo.class), (String)"SDK_OPERATION_BINDING", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(codeBlock).build();
    }
}

