/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.utils.CollectionUtils;

public final class BeanGetterHelper {
    private final PoetExtensions poetExtensions;
    private final TypeProvider typeProvider;

    public BeanGetterHelper(PoetExtensions poetExtensions, TypeProvider typeProvider) {
        this.poetExtensions = poetExtensions;
        this.typeProvider = typeProvider;
    }

    public MethodSpec beanStyleGetter(MemberModel memberModel) {
        if (memberModel.hasBuilder()) {
            return this.builderGetter(memberModel);
        }
        if (memberModel.isCollectionWithBuilderMember()) {
            return memberModel.isList() ? this.listOfBuildersGetter(memberModel) : this.mapOfBuildersGetter(memberModel);
        }
        if (memberModel.isSdkBytesType()) {
            return this.byteBufferGetter(memberModel);
        }
        if (memberModel.isList() && memberModel.getListModel().getListMemberModel().isSdkBytesType()) {
            return this.listByteBufferGetter(memberModel);
        }
        if (memberModel.isMap() && memberModel.getMapModel().getValueModel().isSdkBytesType()) {
            return this.mapByteBufferGetter(memberModel);
        }
        return this.regularGetter(memberModel);
    }

    private MethodSpec byteBufferGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, (TypeName)ClassName.get(ByteBuffer.class), CodeBlock.of((String)"return $1N == null ? null : $1N.asByteBuffer()", (Object[])new Object[]{memberModel.getVariable().getVariableName()}));
    }

    private MethodSpec listByteBufferGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, (TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{ByteBuffer.class}), CodeBlock.of((String)"return $1N == null ? null : $1N.stream().map($2T::asByteBuffer).collect($3T.toList())", (Object[])new Object[]{memberModel.getVariable().getVariableName(), SdkBytes.class, Collectors.class}));
    }

    private MethodSpec mapByteBufferGetter(MemberModel memberModel) {
        String body = "return $1N == null ? null : $1N.entrySet().stream().collect($2T.toMap(e -> e.getKey(), e -> e.getValue().asByteBuffer()))";
        String keyType = memberModel.getMapModel().getKeyModel().getVariable().getVariableType();
        return this.basicGetter(memberModel, (TypeName)PoetUtils.createParameterizedTypeName(Map.class, keyType, ByteBuffer.class.getSimpleName()), CodeBlock.of((String)body, (Object[])new Object[]{memberModel.getVariable().getVariableName(), Collectors.class}));
    }

    private MethodSpec regularGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, this.typeProvider.parameterType(memberModel), CodeBlock.of((String)"return $N", (Object[])new Object[]{memberModel.getVariable().getVariableName()}));
    }

    private MethodSpec builderGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, (TypeName)this.poetExtensions.getModelClass(memberModel.getC2jShape()).nestedClass("Builder"), CodeBlock.builder().add("return $1N != null ? $1N.toBuilder() : null", new Object[]{memberModel.getVariable().getVariableName()}).build());
    }

    private MethodSpec mapOfBuildersGetter(MemberModel memberModel) {
        TypeName keyType = this.typeProvider.getTypeNameForSimpleType(memberModel.getMapModel().getKeyModel().getVariable().getVariableType());
        ClassName valueType = this.poetExtensions.getModelClass(memberModel.getMapModel().getValueModel().getC2jShape());
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType.nestedClass("Builder")});
        return this.basicGetter(memberModel, (TypeName)returnType, CodeBlock.builder().add("return $1N != null ? $2T.mapValues($1N, $3T::toBuilder) : null", new Object[]{memberModel.getVariable().getVariableName(), CollectionUtils.class, valueType}).build());
    }

    private MethodSpec listOfBuildersGetter(MemberModel memberModel) {
        ClassName memberType = this.poetExtensions.getModelClass(memberModel.getListModel().getListMemberModel().getC2jShape());
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{memberType.nestedClass("Builder")});
        return this.basicGetter(memberModel, (TypeName)returnType, CodeBlock.builder().add("return $1N != null ? $1N.stream().map($2T::toBuilder).collect($3T.toList()) : null", new Object[]{memberModel.getVariable().getVariableName(), memberType, Collectors.class}).build());
    }

    private MethodSpec basicGetter(MemberModel memberModel, TypeName returnType, CodeBlock statement) {
        return MethodSpec.methodBuilder((String)memberModel.getBeanStyleGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(returnType).addStatement(statement).build();
    }
}

