/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.endpointdiscovery;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;

public class EndpointDiscoveryAsyncCacheLoaderGenerator
implements ClassSpec {
    private static final String CLIENT_FIELD = "client";
    private final IntermediateModel model;
    private final PoetExtensions poetExtensions;

    public EndpointDiscoveryAsyncCacheLoaderGenerator(GeneratorTaskParams generatorTaskParams) {
        this.model = generatorTaskParams.getModel();
        this.poetExtensions = generatorTaskParams.getPoetExtensions();
    }

    @Override
    public TypeSpec poetSpec() {
        return TypeSpec.classBuilder((ClassName)this.className()).addAnnotation(SdkInternalApi.class).addAnnotation(PoetUtils.generatedAnnotation()).addSuperinterface(EndpointDiscoveryCacheLoader.class).addField(FieldSpec.builder((TypeName)this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface()), (String)CLIENT_FIELD, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addMethod(this.constructor()).addMethod(this.create()).addMethod(this.discoverEndpoint(this.model.getEndpointOperation().get())).build();
    }

    @Override
    public ClassName className() {
        return this.poetExtensions.getClientClass(this.model.getNamingStrategy().getServiceName() + "AsyncEndpointDiscoveryCacheLoader");
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addParameter((TypeName)this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface()), CLIENT_FIELD, new Modifier[0]).addStatement("this.$L = $L", new Object[]{CLIENT_FIELD, CLIENT_FIELD}).build();
    }

    private MethodSpec create() {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns((TypeName)this.className()).addParameter((TypeName)this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface()), CLIENT_FIELD, new Modifier[0]).addStatement("return new $T($L)", new Object[]{this.className(), CLIENT_FIELD}).build();
    }

    private MethodSpec discoverEndpoint(OperationModel opModel) {
        ParameterizedTypeName returnType = ParameterizedTypeName.get(CompletableFuture.class, (Type[])new Type[]{EndpointDiscoveryEndpoint.class});
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"discoverEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(EndpointDiscoveryRequest.class, "endpointDiscoveryRequest", new Modifier[0]).returns((TypeName)returnType);
        if (!opModel.getInputShape().isHasHeaderMember()) {
            methodBuilder.addCode("return $L.$L($L.builder().build()).thenApply(r -> {", new Object[]{CLIENT_FIELD, opModel.getMethodName(), this.poetExtensions.getModelClass(opModel.getInputShape().getC2jName())}).addStatement("$T endpoint = r.endpoints().get(0)", new Object[]{this.poetExtensions.getModelClass("Endpoint")}).addStatement("return $T.builder().endpoint(toUri(endpoint.address(), $L.defaultEndpoint())).expirationTime($T.now().plus(endpoint.cachePeriodInMinutes(), $T.MINUTES)).build()", new Object[]{EndpointDiscoveryEndpoint.class, "endpointDiscoveryRequest", Instant.class, ChronoUnit.class}).addStatement("})", new Object[0]);
        }
        return methodBuilder.build();
    }
}

