/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.QueryProtocolSpec;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;

public final class XmlProtocolSpec
extends QueryProtocolSpec {
    private final IntermediateModel model;

    public XmlProtocolSpec(IntermediateModel model, PoetExtensions poetExtensions) {
        super(poetExtensions);
        this.model = model;
    }

    @Override
    protected Class<?> protocolFactoryClass() {
        if (this.model.getCustomizationConfig().getCustomProtocolFactoryFqcn() != null) {
            try {
                return Class.forName(this.model.getCustomizationConfig().getCustomProtocolFactoryFqcn());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find custom protocol factory class", e);
            }
        }
        return AwsXmlProtocolFactory.class;
    }

    @Override
    public CodeBlock responseHandler(IntermediateModel model, OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = protocolFactory.createResponseHandler($T::builder,new $T().withHasStreamingSuccessResponse($L))", new Object[]{HttpResponseHandler.class, responseType, responseType, XmlOperationMetadata.class, opModel.hasStreamingOutput()}).build();
    }
}

