/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.utils.Validate;

public final class AuthSchemeCodegenMetadata {
    private final String schemeId;
    private final List<SignerPropertyValueProvider> properties;
    private final Class<?> authSchemeClass;

    private AuthSchemeCodegenMetadata(Builder builder) {
        this.schemeId = (String)Validate.paramNotNull((Object)builder.schemeId, (String)"schemeId");
        this.properties = Collections.unmodifiableList((List)Validate.paramNotNull((Object)builder.properties, (String)"properties"));
        this.authSchemeClass = (Class)Validate.paramNotNull((Object)builder.authSchemeClass, (String)"authSchemeClass");
    }

    public String schemeId() {
        return this.schemeId;
    }

    public Class<?> authSchemeClass() {
        return this.authSchemeClass;
    }

    public List<SignerPropertyValueProvider> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    static class SignerPropertyValueProvider {
        private final Class<?> containingClass;
        private final String fieldName;
        private final BiConsumer<CodeBlock.Builder, AuthSchemeSpecUtils> valueEmitter;
        private final Supplier<Object> valueSupplier;

        SignerPropertyValueProvider(Builder builder) {
            this.containingClass = (Class)Validate.paramNotNull((Object)builder.containingClass, (String)"containingClass");
            this.valueEmitter = (BiConsumer)Validate.paramNotNull((Object)builder.valueEmitter, (String)"valueEmitter");
            this.fieldName = (String)Validate.paramNotNull((Object)builder.fieldName, (String)"fieldName");
            this.valueSupplier = builder.valueSupplier;
        }

        public Class<?> containingClass() {
            return this.containingClass;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public boolean isConstant() {
            return this.valueSupplier != null;
        }

        public Object value() {
            return this.valueSupplier.get();
        }

        public void emitValue(CodeBlock.Builder spec, AuthSchemeSpecUtils utils) {
            this.valueEmitter.accept(spec, utils);
        }

        public static Builder builder() {
            return new Builder();
        }

        static class Builder {
            private Class<?> containingClass;
            private String fieldName;
            private BiConsumer<CodeBlock.Builder, AuthSchemeSpecUtils> valueEmitter;
            private Supplier<Object> valueSupplier;

            Builder() {
            }

            public Builder containingClass(Class<?> containingClass) {
                this.containingClass = containingClass;
                return this;
            }

            public Builder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public Builder valueEmitter(BiConsumer<CodeBlock.Builder, AuthSchemeSpecUtils> valueEmitter) {
                this.valueEmitter = valueEmitter;
                return this;
            }

            public Builder constantValueSupplier(Supplier<Object> valueSupplier) {
                this.valueSupplier = valueSupplier;
                if (this.valueEmitter == null) {
                    this.valueEmitter = (spec, utils) -> spec.add("$L", new Object[]{valueSupplier.get()});
                }
                return this;
            }

            public SignerPropertyValueProvider build() {
                return new SignerPropertyValueProvider(this);
            }
        }
    }

    public static class Builder {
        private String schemeId;
        private List<SignerPropertyValueProvider> properties = new ArrayList<SignerPropertyValueProvider>();
        private Class<?> authSchemeClass;

        Builder() {
        }

        Builder(AuthSchemeCodegenMetadata other) {
            this.schemeId = other.schemeId;
            this.properties.addAll(other.properties);
            this.authSchemeClass = other.authSchemeClass;
        }

        public Builder schemeId(String schemeId) {
            this.schemeId = schemeId;
            return this;
        }

        public Builder addProperty(SignerPropertyValueProvider property) {
            this.properties.add(property);
            return this;
        }

        public Builder properties(List<SignerPropertyValueProvider> properties) {
            this.properties.clear();
            this.properties.addAll(properties);
            return this;
        }

        public Builder authSchemeClass(Class<?> authSchemeClass) {
            this.authSchemeClass = authSchemeClass;
            return this;
        }

        public AuthSchemeCodegenMetadata build() {
            return new AuthSchemeCodegenMetadata(this);
        }
    }
}

