/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.EndpointExpression;
import software.amazon.awssdk.codegen.poet.rules2.ErrorExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class RuleSetExpression
implements RuleExpression {
    private final RuleType type = RuleRuntimeTypeMirror.VOID;
    private final List<RuleExpression> conditions;
    private final List<RuleSetExpression> children;
    private final ErrorExpression error;
    private final EndpointExpression endpoint;
    private final String ruleId;

    RuleSetExpression(Builder builder) {
        this.conditions = builder.conditions.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(builder.conditions));
        if (!builder.children.isEmpty()) {
            Validate.isNull((Object)builder.error, (String)"RuleSet with children cannot have error result", (Object[])new Object[0]);
            Validate.isNull((Object)builder.endpoint, (String)"RuleSet with children cannot have endpoint result", (Object[])new Object[0]);
            this.children = Collections.unmodifiableList(new ArrayList(builder.children));
            this.error = null;
            this.endpoint = null;
        } else if (builder.endpoint != null) {
            Validate.isNull((Object)builder.error, (String)"RuleSet with endpoint cannot have error result", (Object[])new Object[0]);
            this.children = null;
            this.error = null;
            this.endpoint = builder.endpoint;
        } else if (builder.error != null) {
            Validate.isNull((Object)builder.endpoint, (String)"RuleSet with error cannot have endpoint result", (Object[])new Object[0]);
            this.children = null;
            this.error = builder.error;
            this.endpoint = null;
        } else {
            throw new IllegalArgumentException("At exactly one of error, endpoint or tree, none given");
        }
        this.ruleId = builder.ruleId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.RULE_SET;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("{:type ");
        if (this.isEndpoint()) {
            buf.append(":endpoint");
            RuleSetExpression.appendConditions(buf, this.conditions);
            buf.append(", :endpoint ");
            this.endpoint.appendTo(buf);
        } else if (this.isError()) {
            buf.append(":error");
            RuleSetExpression.appendConditions(buf, this.conditions);
            buf.append(", :error ");
            this.error.appendTo(buf);
        } else if (this.isTree()) {
            buf.append(":tree");
            RuleSetExpression.appendConditions(buf, this.conditions);
            buf.append(", :tree [");
            boolean isFirst = true;
            for (RuleSetExpression expr : this.children) {
                if (!isFirst) {
                    buf.append(", ");
                }
                expr.appendTo(buf);
                isFirst = false;
            }
            buf.append("]");
        } else {
            buf.append("UNKNOWN");
        }
        buf.append("}");
        return buf;
    }

    static void appendConditions(StringBuilder buf, List<RuleExpression> conditions) {
        buf.append(", :conditions [");
        boolean isFirst = true;
        for (RuleExpression expr : conditions) {
            if (!isFirst) {
                buf.append(", ");
            }
            expr.appendTo(buf);
            isFirst = false;
        }
        buf.append("]");
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitRuleSetExpression(this);
    }

    public List<RuleExpression> conditions() {
        return this.conditions;
    }

    public List<RuleSetExpression> children() {
        return this.children;
    }

    public ErrorExpression error() {
        return this.error;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public EndpointExpression endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean isEndpoint() {
        return this.endpoint != null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public boolean isTree() {
        return this.endpoint == null && this.error == null;
    }

    public String category() {
        if (this.isEndpoint()) {
            return "endpoint";
        }
        if (this.isError()) {
            return "error";
        }
        return "tree";
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSetExpression that = (RuleSetExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.children, that.children)) {
            return false;
        }
        if (!Objects.equals(this.error, that.error)) {
            return false;
        }
        if (!Objects.equals(this.endpoint, that.endpoint)) {
            return false;
        }
        return Objects.equals(this.ruleId, that.ruleId);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
        result = 31 * result + (this.ruleId != null ? this.ruleId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public static class Builder {
        private final List<RuleExpression> conditions = new ArrayList<RuleExpression>();
        private final List<RuleSetExpression> children = new ArrayList<RuleSetExpression>();
        private ErrorExpression error;
        private EndpointExpression endpoint;
        private String ruleId;

        public Builder() {
        }

        public Builder(RuleSetExpression expr) {
            this.conditions.addAll(expr.conditions);
            if (expr.children != null) {
                this.children.addAll(expr.children);
            }
            this.error = expr.error;
            this.endpoint = expr.endpoint;
            this.ruleId = expr.ruleId;
        }

        public Builder conditions(List<RuleExpression> conditions) {
            this.conditions.clear();
            this.conditions.addAll(conditions);
            return this;
        }

        public Builder addCondition(RuleExpression condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder clearConditions() {
            this.conditions.clear();
            return this;
        }

        public Builder addChildren(RuleSetExpression expr) {
            this.children.add(expr);
            return this;
        }

        public Builder clearChildren() {
            this.children.clear();
            return this;
        }

        public Builder childern(List<RuleSetExpression> children) {
            this.children.clear();
            this.children.addAll(children);
            return this;
        }

        public Builder error(ErrorExpression error) {
            this.error = error;
            return this;
        }

        public Builder endpoint(EndpointExpression endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public RuleSetExpression build() {
            return new RuleSetExpression(this);
        }
    }
}

