/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.poet.rules2.LetExpression;
import software.amazon.awssdk.codegen.poet.rules2.MemberAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.RewriteRuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;
import software.amazon.awssdk.codegen.poet.rules2.VariableReferenceExpression;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public final class RenameForCodegenVisitor
extends RewriteRuleExpressionVisitor {
    private final SymbolTable symbolTable;
    private final SymbolTable.Builder renames;

    public RenameForCodegenVisitor(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.renames = SymbolTable.builder();
    }

    public SymbolTable symbolTable() {
        String regionParamName = this.symbolTable.regionParamName();
        if (regionParamName != null) {
            this.renames.regionParamName(this.javaName(regionParamName));
        }
        return this.renames.build();
    }

    @Override
    public RuleExpression visitVariableReferenceExpression(VariableReferenceExpression e) {
        String name = e.variableName();
        if (this.symbolTable.isLocal(name)) {
            RuleType type = this.symbolTable.localType(name);
            String newName = this.javaName(name);
            this.renames.putLocal(newName, type);
            return VariableReferenceExpression.builder().variableName(newName).build();
        }
        if (this.symbolTable.isParam(name)) {
            RuleType type = this.symbolTable.paramType(name);
            String newName = this.javaName(name);
            this.renames.putParam(newName, type);
            return MemberAccessExpression.builder().type(e.type()).source(VariableReferenceExpression.builder().variableName("params").build()).name(newName).build();
        }
        return e;
    }

    @Override
    public RuleExpression visitLetExpression(LetExpression e) {
        LetExpression.Builder builder = LetExpression.builder();
        e.bindings().forEach((k, v) -> {
            String newName = this.javaName((String)k);
            RuleExpression value = v.accept(this);
            builder.putBinding(newName, value);
            this.renames.putLocal(newName, value.type());
        });
        return builder.build();
    }

    private String javaName(String name) {
        return Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)name));
    }
}

