/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.List;
import software.amazon.awssdk.codegen.poet.rules2.BooleanNotExpression;
import software.amazon.awssdk.codegen.poet.rules2.FunctionCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.IndexedAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralBooleanExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralIntegerExpression;
import software.amazon.awssdk.codegen.poet.rules2.MethodCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.RewriteRuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;

public final class PrepareForCodegenVisitor
extends RewriteRuleExpressionVisitor {
    @Override
    public RuleExpression visitBooleanNotExpression(BooleanNotExpression e) {
        FunctionCallExpression functionCall;
        RuleExpression arg = (e = (BooleanNotExpression)super.visitBooleanNotExpression(e)).expression();
        if (arg instanceof FunctionCallExpression && "isSet".equals((functionCall = (FunctionCallExpression)arg).name())) {
            return functionCall.toBuilder().name("isNotSet").build();
        }
        return e;
    }

    @Override
    public RuleExpression visitFunctionCallExpression(FunctionCallExpression e) {
        String fn;
        e = (FunctionCallExpression)super.visitFunctionCallExpression(e);
        switch (fn = e.name()) {
            case "booleanEquals": {
                return this.simplifyBooleanEquals(e);
            }
            case "stringEquals": {
                return this.simplifyStringEquals(e);
            }
            case "not": {
                return this.simplifyNotExpression(e);
            }
        }
        return e;
    }

    @Override
    public RuleExpression visitIndexedAccessExpression(IndexedAccessExpression e) {
        e = (IndexedAccessExpression)super.visitIndexedAccessExpression(e);
        return FunctionCallExpression.builder().name("listAccess").type(e.type()).addArgument(e.source()).addArgument(new LiteralIntegerExpression(e.index())).build();
    }

    private RuleExpression simplifyBooleanEquals(FunctionCallExpression e) {
        List<RuleExpression> args = e.arguments();
        RuleExpression left = args.get(0).accept(this);
        RuleExpression right = args.get(1).accept(this);
        if (left.kind() == RuleExpression.RuleExpressionKind.BOOLEAN_VALUE) {
            LiteralBooleanExpression leftAsBoolean = (LiteralBooleanExpression)left;
            if (leftAsBoolean.value()) {
                return right;
            }
            return BooleanNotExpression.builder().expression(right).build();
        }
        if (right.kind() == RuleExpression.RuleExpressionKind.BOOLEAN_VALUE) {
            LiteralBooleanExpression rightAsBoolean = (LiteralBooleanExpression)right;
            if (rightAsBoolean.value()) {
                return left;
            }
            return BooleanNotExpression.builder().expression(left).build();
        }
        return MethodCallExpression.builder().name("equals").source(left).addArgument(right).build();
    }

    private RuleExpression simplifyStringEquals(FunctionCallExpression e) {
        List<RuleExpression> args = e.arguments();
        RuleExpression left = args.get(0).accept(this);
        RuleExpression right = args.get(1).accept(this);
        if (right.kind() == RuleExpression.RuleExpressionKind.STRING_VALUE) {
            return MethodCallExpression.builder().name("equals").source(right).addArgument(left).build();
        }
        if (left.kind() == RuleExpression.RuleExpressionKind.STRING_VALUE) {
            return MethodCallExpression.builder().name("equals").source(left).addArgument(right).build();
        }
        return e;
    }

    private RuleExpression simplifyNotExpression(FunctionCallExpression e) {
        FunctionCallExpression inner;
        RuleExpression arg = e.arguments().get(0);
        if (arg instanceof FunctionCallExpression && "isSet".equals((inner = (FunctionCallExpression)arg).name())) {
            return inner.toBuilder().name("isNotSet").build();
        }
        return e;
    }
}

