/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.utils.CollectionUtils;

public class PreferredAuthSchemeProviderSpec
implements ClassSpec {
    private final AuthSchemeSpecUtils authSchemeSpecUtils;

    public PreferredAuthSchemeProviderSpec(IntermediateModel intermediateModel) {
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(intermediateModel);
    }

    @Override
    public ClassName className() {
        return this.authSchemeSpecUtils.preferredAuthSchemeProviderName();
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addField((TypeName)this.authSchemeSpecUtils.providerInterfaceName(), "delegate", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), "authSchemePreference", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addSuperinterface((TypeName)this.authSchemeSpecUtils.providerInterfaceName()).addMethod(this.constructor()).addMethod(this.resolveAuthSchemeMethod()).build();
    }

    private MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.authSchemeSpecUtils.providerInterfaceName(), "delegate", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), "authSchemePreference", new Modifier[0]).addStatement("this.delegate = delegate", new Object[0]).addStatement("this.authSchemePreference = authSchemePreference != null ? authSchemePreference : $T.emptyList()", new Object[]{Collections.class}).build();
    }

    private MethodSpec resolveAuthSchemeMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolveAuthScheme").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.authSchemeSpecUtils.resolverReturnType()).addParameter((TypeName)this.authSchemeSpecUtils.parametersInterfaceName(), "params", new Modifier[0]);
        b.addJavadoc("Resolve the auth schemes based on the given set of parameters.", new Object[0]);
        b.addStatement("$T candidateAuthSchemes = delegate.resolveAuthScheme(params)", new Object[]{this.authSchemeSpecUtils.resolverReturnType()});
        b.beginControlFlow("if ($T.isNullOrEmpty(authSchemePreference))", new Object[]{CollectionUtils.class}).addStatement("return candidateAuthSchemes", new Object[0]).endControlFlow();
        b.addStatement("$T authSchemes = new $T<>()", new Object[]{this.authSchemeSpecUtils.resolverReturnType(), ArrayList.class});
        b.beginControlFlow("authSchemePreference.forEach(preferredSchemeId -> ", new Object[0]);
        b.beginControlFlow("candidateAuthSchemes.stream().filter(candidate -> ", new Object[0]);
        b.addStatement("String candidateSchemeName = candidate.schemeId().contains(\"#\") ? candidate.schemeId().split(\"#\")[1] : candidate.schemeId()", new Object[0]);
        b.addStatement("return candidateSchemeName.equals(preferredSchemeId)", new Object[0]);
        b.endControlFlow(").findFirst().ifPresent(authSchemes::add)", new Object[0]);
        b.endControlFlow(")", new Object[0]);
        b.beginControlFlow("candidateAuthSchemes.forEach(candidate -> ", new Object[0]).beginControlFlow("if (!authSchemes.contains(candidate))", new Object[0]).addStatement("authSchemes.add(candidate)", new Object[0]).endControlFlow().endControlFlow(")", new Object[0]);
        b.addStatement("return authSchemes", new Object[0]);
        return b.build();
    }
}

