/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.traits;

import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.codegen.checksum.HttpChecksum;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ImmutableMap;

public class HttpChecksumTrait {
    private static final Map<String, Integer> CHECKSUM_ALGORITHM_PRIORITY = ImmutableMap.builder().put((Object)DefaultChecksumAlgorithm.CRC32C.algorithmId(), (Object)1).put((Object)DefaultChecksumAlgorithm.CRC32.algorithmId(), (Object)2).put((Object)DefaultChecksumAlgorithm.CRC64NVME.algorithmId(), (Object)3).put((Object)DefaultChecksumAlgorithm.SHA1.algorithmId(), (Object)4).put((Object)DefaultChecksumAlgorithm.SHA256.algorithmId(), (Object)5).build();

    private HttpChecksumTrait() {
    }

    public static CodeBlock create(OperationModel operationModel) {
        String responseValidationModeMember;
        HttpChecksum httpChecksum = operationModel.getHttpChecksum();
        if (httpChecksum == null) {
            return CodeBlock.of((String)"", (Object[])new Object[0]);
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.add(CodeBlock.of((String)".putExecutionAttribute($T.HTTP_CHECKSUM, $T.builder().requestChecksumRequired($L).isRequestStreaming($L)", (Object[])new Object[]{SdkInternalExecutionAttribute.class, software.amazon.awssdk.core.interceptor.trait.HttpChecksum.class, httpChecksum.isRequestChecksumRequired(), operationModel.getInputShape().isHasStreamingMember()}));
        String requestAlgorithmMember = httpChecksum.getRequestAlgorithmMember();
        if (requestAlgorithmMember != null) {
            HttpChecksumTrait.configureRequestChecksumCalculation(operationModel, requestAlgorithmMember, codeBuilder);
        }
        if ((responseValidationModeMember = httpChecksum.getRequestValidationModeMember()) != null) {
            HttpChecksumTrait.configureResponseChecksumValidation(operationModel, responseValidationModeMember, codeBuilder, httpChecksum);
        }
        return codeBuilder.add(CodeBlock.of((String)".build())", (Object[])new Object[0])).build();
    }

    private static void configureResponseChecksumValidation(OperationModel operationModel, String responseValidationModeMember, CodeBlock.Builder codeBuilder, HttpChecksum httpChecksum) {
        MemberModel checksumMember = operationModel.getInputShape().tryFindMemberModelByC2jName(responseValidationModeMember, true);
        if (checksumMember == null) {
            throw new IllegalStateException(responseValidationModeMember + " is not a member in " + operationModel.getInputShape().getShapeName());
        }
        codeBuilder.add(".requestValidationMode($N.$N())", new Object[]{operationModel.getInput().getVariableName(), checksumMember.getFluentGetterMethodName()});
        List<String> responseAlgorithms = httpChecksum.getResponseAlgorithms();
        if (!CollectionUtils.isNullOrEmpty(responseAlgorithms)) {
            HttpChecksumTrait.addResponseAlgorithmsCodeBlock(responseAlgorithms, codeBuilder);
        }
    }

    private static void configureRequestChecksumCalculation(OperationModel operationModel, String requestAlgorithmMember, CodeBlock.Builder codeBuilder) {
        MemberModel requestAlgorithm = operationModel.getInputShape().tryFindMemberModelByC2jName(requestAlgorithmMember, true);
        if (requestAlgorithm == null) {
            throw new IllegalStateException(requestAlgorithmMember + " is not a member in " + operationModel.getInputShape().getShapeName());
        }
        codeBuilder.add(".requestAlgorithm($N.$N())", new Object[]{operationModel.getInput().getVariableName(), requestAlgorithm.getFluentGetterMethodName()});
        if (requestAlgorithm.getHttp().getMarshallLocation() != MarshallLocation.HEADER) {
            throw new IllegalStateException("Unsupported request algorithm location for " + requestAlgorithm);
        }
        String headerName = requestAlgorithm.getHttp().getMarshallLocationName();
        if (headerName == null) {
            throw new IllegalStateException("Request algorithm header name is null for " + requestAlgorithm);
        }
        codeBuilder.add(".requestAlgorithmHeader($S)", new Object[]{headerName});
    }

    private static void addResponseAlgorithmsCodeBlock(List<String> responseAlgorithms, CodeBlock.Builder codeBuilder) {
        List<String> sortedResponseAlgorithms = responseAlgorithms.stream().sorted(Comparator.comparingInt(o -> CHECKSUM_ALGORITHM_PRIORITY.getOrDefault(o.toUpperCase(Locale.US), Integer.MAX_VALUE))).collect(Collectors.toList());
        codeBuilder.add(CodeBlock.of((String)".responseAlgorithmsV2(", (Object[])new Object[0]));
        List<CodeBlock> responseAlgorithmsCodeBlocks = HttpChecksumTrait.responseAlgorithmsCodeBlocks(sortedResponseAlgorithms);
        for (int i = 0; i < responseAlgorithmsCodeBlocks.size(); ++i) {
            CodeBlock code = responseAlgorithmsCodeBlocks.get(i);
            codeBuilder.add(code);
            if (i == responseAlgorithmsCodeBlocks.size() - 1) continue;
            codeBuilder.add(",", new Object[0]);
        }
        codeBuilder.add(CodeBlock.of((String)")", (Object[])new Object[0]));
    }

    private static List<CodeBlock> responseAlgorithmsCodeBlocks(List<String> responseAlgorithms) {
        ArrayList<CodeBlock> list = new ArrayList<CodeBlock>();
        for (String algo : responseAlgorithms) {
            String algorithmName = algo.toUpperCase(Locale.US);
            if (!CHECKSUM_ALGORITHM_PRIORITY.containsKey(algorithmName)) {
                throw new UnsupportedOperationException("Unsupported algorithm: " + algorithmName);
            }
            CodeBlock codeBlock = CodeBlock.of((String)"$T.$L", (Object[])new Object[]{DefaultChecksumAlgorithm.class, algorithmName});
            list.add(codeBlock);
        }
        return list;
    }

    public static boolean hasRequestAlgorithmMember(IntermediateModel model) {
        Predicate<HttpChecksum> requestCalculation = httpChecksum -> httpChecksum.getRequestAlgorithmMember() != null || httpChecksum.isRequestChecksumRequired();
        return model.getOperations().values().stream().filter(operationModel -> operationModel.getHttpChecksum() != null).anyMatch(opModel -> requestCalculation.test(opModel.getHttpChecksum()));
    }

    public static boolean hasResponseAlgorithms(IntermediateModel model) {
        return model.getOperations().values().stream().anyMatch(opModel -> opModel.getHttpChecksum() != null && opModel.getHttpChecksum().getResponseAlgorithms() != null);
    }
}

