/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class MemberAccessExpression
implements RuleExpression {
    private final RuleType type;
    private final RuleExpression source;
    private final String name;
    private final boolean directIndex;

    MemberAccessExpression(Builder builder) {
        this.type = builder.type;
        this.source = (RuleExpression)Validate.paramNotNull((Object)builder.source, (String)"source");
        this.directIndex = builder.directIndex != null ? builder.directIndex : false;
        this.name = this.directIndex ? builder.name : (String)Validate.paramNotNull((Object)builder.name, (String)"name");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.MEMBER_ACCESS;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("(get-member ");
        this.source.appendTo(buf);
        buf.append(" ");
        buf.append(this.name);
        return buf.append(")");
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitMemberAccessExpression(this);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public RuleExpression source() {
        return this.source;
    }

    public String name() {
        return this.name;
    }

    public boolean directIndex() {
        return this.directIndex;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberAccessExpression that = (MemberAccessExpression)o;
        if (this.directIndex != that.directIndex) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Boolean.hashCode(this.directIndex);
        return result;
    }

    public static class Builder {
        private RuleType type;
        private RuleExpression source;
        private String name;
        private Boolean directIndex;

        private Builder() {
        }

        private Builder(MemberAccessExpression expr) {
            this.type = expr.type;
            this.source = expr.source;
            this.name = expr.name;
            this.directIndex = expr.directIndex;
        }

        public Builder source(RuleExpression source) {
            this.source = source;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(RuleType type) {
            this.type = type;
            return this;
        }

        public Builder directIndex(Boolean directIndex) {
            this.directIndex = directIndex;
            return this;
        }

        public MemberAccessExpression build() {
            return new MemberAccessExpression(this);
        }
    }
}

