/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform.protocols;

import com.squareup.javapoet.CodeBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.poet.transform.protocols.CodegenSerializerResolver;
import software.amazon.awssdk.utils.MapUtils;

public interface CodegenSerializer<T> {
    public void serialize(T var1, CodeBlock.Builder var2);

    public static class CodegenMapSerializer
    implements CodegenSerializer<Map<?, ?>> {
        private final CodegenSerializerResolver resolver;

        public CodegenMapSerializer(CodegenSerializerResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public void serialize(Map<?, ?> map, CodeBlock.Builder builder) {
            builder.add("$T.of(", new Object[]{MapUtils.class});
            boolean needsComma = false;
            for (Map.Entry<?, ?> kvp : map.entrySet()) {
                if (needsComma) {
                    builder.add(", ", new Object[0]);
                }
                Object key = kvp.getKey();
                CodegenSerializer<?> keySerializer = this.resolver.serializerFor(key);
                keySerializer.serialize(key, builder);
                builder.add(", ", new Object[0]);
                Object value = kvp.getValue();
                CodegenSerializer<?> valueSerializer = this.resolver.serializerFor(value);
                valueSerializer.serialize(value, builder);
                needsComma = true;
            }
            builder.add(")", new Object[0]);
        }
    }

    public static class CodegenListSerializer
    implements CodegenSerializer<List<?>> {
        private final CodegenSerializerResolver resolver;

        public CodegenListSerializer(CodegenSerializerResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public void serialize(List<?> list, CodeBlock.Builder builder) {
            builder.add("$T.asList(", new Object[]{Arrays.class});
            boolean needsComma = false;
            for (Object value : list) {
                if (needsComma) {
                    builder.add(", ", new Object[0]);
                }
                CodegenSerializer<?> serializer = this.resolver.serializerFor(value);
                serializer.serialize(value, builder);
                needsComma = true;
            }
            builder.add(")", new Object[0]);
        }
    }

    public static class CodegenLiteralSerializer
    implements CodegenSerializer<Object> {
        @Override
        public void serialize(Object value, CodeBlock.Builder builder) {
            builder.add("$L", new Object[]{value});
        }
    }

    public static class CodegenStringSerializer
    implements CodegenSerializer<String> {
        @Override
        public void serialize(String value, CodeBlock.Builder builder) {
            builder.add("$S", new Object[]{value});
        }
    }
}

