/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class BooleanNotExpression
implements RuleExpression {
    private final RuleType type = RuleRuntimeTypeMirror.BOOLEAN;
    private final RuleExpression expression;

    BooleanNotExpression(Builder builder) {
        this.expression = (RuleExpression)Validate.paramNotNull((Object)builder.expression, (String)"expression");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.BOOLEAN_NOT;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("(not ");
        this.expression.appendTo(buf);
        return buf.append(')');
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitBooleanNotExpression(this);
    }

    public RuleExpression expression() {
        return this.expression;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanNotExpression that = (BooleanNotExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.expression.hashCode();
        return result;
    }

    public static class Builder {
        private RuleExpression expression;

        public Builder expression(RuleExpression expression) {
            this.expression = expression;
            return this;
        }

        public BooleanNotExpression build() {
            return new BooleanNotExpression(this);
        }
    }
}

