/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.emitters.tasks.JmesPathRuntimeGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.RulesEngineRuntimeGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.RulesEngineRuntimeGeneratorTask2;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.poet.rules.ClientContextParamsClassSpec;
import software.amazon.awssdk.codegen.poet.rules.DefaultPartitionDataProviderSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointParametersClassSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointProviderInterfaceSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointProviderSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointProviderTestSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointResolverInterceptorSpec;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesClientTestSpec;
import software.amazon.awssdk.codegen.poet.rules.RequestEndpointInterceptorSpec;
import software.amazon.awssdk.codegen.poet.rules2.EndpointProviderSpec2;

public final class EndpointProviderTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public EndpointProviderTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> tasks = new ArrayList<GeneratorTask>();
        tasks.add(this.generateInterface());
        tasks.add(this.generateParams());
        if (this.shouldGenerateCompiledEndpointRules()) {
            tasks.add(this.generateDefaultProvider2());
            tasks.add(new RulesEngineRuntimeGeneratorTask(this.generatorTaskParams));
            tasks.add(new RulesEngineRuntimeGeneratorTask2(this.generatorTaskParams));
        } else {
            tasks.add(this.generateDefaultProvider());
            tasks.add(new RulesEngineRuntimeGeneratorTask(this.generatorTaskParams));
        }
        if (this.shouldGenerateJmesPathRuntime()) {
            tasks.add(new JmesPathRuntimeGeneratorTask(this.generatorTaskParams));
        }
        tasks.addAll(this.generateInterceptors());
        if (this.shouldGenerateEndpointTests()) {
            tasks.add(this.generateProviderTests());
        }
        if (this.shouldGenerateEndpointTests() && this.shouldGenerateClientEndpointTests()) {
            tasks.add(this.generateClientTests());
        }
        if (this.hasClientContextParams()) {
            tasks.add(this.generateClientContextParams());
        }
        tasks.add(this.generateDefaultPartitionsProvider());
        return tasks;
    }

    private GeneratorTask generateInterface() {
        return new PoetGeneratorTask(this.endpointRulesDir(), this.model.getFileHeader(), new EndpointProviderInterfaceSpec(this.model));
    }

    private GeneratorTask generateParams() {
        return new PoetGeneratorTask(this.endpointRulesDir(), this.model.getFileHeader(), new EndpointParametersClassSpec(this.model));
    }

    private GeneratorTask generateDefaultProvider() {
        return new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new EndpointProviderSpec(this.model));
    }

    private GeneratorTask generateDefaultProvider2() {
        return new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new EndpointProviderSpec2(this.model));
    }

    private GeneratorTask generateDefaultPartitionsProvider() {
        return new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new DefaultPartitionDataProviderSpec(this.model));
    }

    private boolean shouldGenerateCompiledEndpointRules() {
        CustomizationConfig customizationConfig = this.generatorTaskParams.getModel().getCustomizationConfig();
        return customizationConfig.isEnableGenerateCompiledEndpointRules();
    }

    private Collection<GeneratorTask> generateInterceptors() {
        return Arrays.asList(new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new EndpointResolverInterceptorSpec(this.model)), new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new RequestEndpointInterceptorSpec(this.model)));
    }

    private GeneratorTask generateClientTests() {
        return new PoetGeneratorTask(this.endpointTestsDir(), this.model.getFileHeader(), new EndpointRulesClientTestSpec(this.model));
    }

    private GeneratorTask generateProviderTests() {
        return new PoetGeneratorTask(this.endpointTestsDir(), this.model.getFileHeader(), new EndpointProviderTestSpec(this.model));
    }

    private GeneratorTask generateClientContextParams() {
        return new PoetGeneratorTask(this.endpointRulesInternalDir(), this.model.getFileHeader(), new ClientContextParamsClassSpec(this.model));
    }

    private String endpointRulesDir() {
        return this.generatorTaskParams.getPathProvider().getEndpointRulesDirectory();
    }

    private String endpointRulesInternalDir() {
        return this.generatorTaskParams.getPathProvider().getEndpointRulesInternalDirectory();
    }

    private String endpointTestsDir() {
        return this.generatorTaskParams.getPathProvider().getEndpointRulesTestDirectory();
    }

    private boolean shouldGenerateEndpointTests() {
        CustomizationConfig customizationConfig = this.generatorTaskParams.getModel().getCustomizationConfig();
        return !Boolean.TRUE.equals(customizationConfig.isSkipEndpointTestGeneration()) && !this.generatorTaskParams.getModel().getEndpointTestSuiteModel().getTestCases().isEmpty();
    }

    private boolean shouldGenerateClientEndpointTests() {
        boolean generateEndpointClientTests = this.generatorTaskParams.getModel().getCustomizationConfig().isGenerateEndpointClientTests();
        boolean someTestCasesHaveOperationInputs = this.model.getEndpointTestSuiteModel().getTestCases().stream().anyMatch(t -> t.getOperationInputs() != null);
        return generateEndpointClientTests || someTestCasesHaveOperationInputs;
    }

    private boolean hasClientContextParams() {
        Map<String, ClientContextParam> clientContextParams = this.model.getClientContextParams();
        Map<String, ClientContextParam> customClientContextParams = this.model.getCustomizationConfig().getCustomClientContextParams();
        return clientContextParams != null && !clientContextParams.isEmpty() || customClientContextParams != null && !customClientContextParams.isEmpty();
    }

    private boolean shouldGenerateJmesPathRuntime() {
        boolean isAlreadyGenerated = this.model.hasWaiters();
        if (isAlreadyGenerated) {
            return true;
        }
        Map<String, ParameterModel> endpointParameters = this.model.getCustomizationConfig().getEndpointParameters();
        if (endpointParameters == null) {
            return false;
        }
        return endpointParameters.values().stream().anyMatch(this::paramRequiresPathParserRuntime);
    }

    private boolean paramRequiresPathParserRuntime(ParameterModel parameterModel) {
        return this.paramIsOperationalContextParam(parameterModel) && "stringarray".equals(parameterModel.getType().toLowerCase(Locale.US));
    }

    private boolean paramIsOperationalContextParam(ParameterModel parameterModel) {
        return true;
    }
}

