/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;

public class AuthSchemeProviderSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final AuthSchemeSpecUtils authSchemeSpecUtils;

    public AuthSchemeProviderSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(intermediateModel);
    }

    @Override
    public ClassName className() {
        return this.authSchemeSpecUtils.providerInterfaceName();
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createInterfaceBuilder(this.className()).addSuperinterface(AuthSchemeProvider.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(SdkPublicApi.class).addJavadoc(this.interfaceJavadoc()).addMethod(this.resolveAuthSchemeMethod()).addMethod(this.resolveAuthSchemeConsumerBuilderMethod()).addMethod(this.defaultProviderMethod()).build();
    }

    private MethodSpec resolveAuthSchemeMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolveAuthScheme");
        b.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        b.addParameter((TypeName)this.authSchemeSpecUtils.parametersInterfaceName(), "authSchemeParams", new Modifier[0]);
        b.returns(this.authSchemeSpecUtils.resolverReturnType());
        b.addJavadoc("Resolve the auth schemes based on the given set of parameters.", new Object[0]);
        return b.build();
    }

    private MethodSpec resolveAuthSchemeConsumerBuilderMethod() {
        ClassName parametersInterface = this.authSchemeSpecUtils.parametersInterfaceName();
        ClassName parametersBuilderInterface = parametersInterface.nestedClass("Builder");
        ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{parametersBuilderInterface});
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolveAuthScheme");
        b.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
        b.addParameter((TypeName)consumerType, "consumer", new Modifier[0]);
        b.returns(this.authSchemeSpecUtils.resolverReturnType());
        b.addJavadoc("Resolve the auth schemes based on the given set of parameters.", new Object[0]);
        b.addStatement("$T builder = $T.builder()", new Object[]{parametersBuilderInterface, parametersInterface});
        b.addStatement("consumer.accept(builder)", new Object[0]);
        b.addStatement("return resolveAuthScheme(builder.build())", new Object[0]);
        return b.build();
    }

    private MethodSpec defaultProviderMethod() {
        return MethodSpec.methodBuilder((String)"defaultProvider").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.className()).addJavadoc("Get the default auth scheme provider.", new Object[0]).addStatement("return $T.create()", new Object[]{this.authSchemeSpecUtils.defaultAuthSchemeProviderName()}).build();
    }

    private CodeBlock interfaceJavadoc() {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("An auth scheme provider for $N service. The auth scheme provider takes a set of parameters using {@link $T}, and resolves a list of {@link $T} based on the given parameters.", new Object[]{this.intermediateModel.getMetadata().getServiceName(), this.authSchemeSpecUtils.parametersInterfaceName(), AuthSchemeOption.class});
        return b.build();
    }
}

