/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.waiters;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.codegen.docs.WaiterDocs;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.WaiterDefinition;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public abstract class BaseWaiterInterfaceSpec
implements ClassSpec {
    private final IntermediateModel model;
    private final Map<String, WaiterDefinition> waiters;
    private final String modelPackage;

    public BaseWaiterInterfaceSpec(IntermediateModel model) {
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.model = model;
        this.waiters = model.getWaiters();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder result = PoetUtils.createInterfaceBuilder(this.className());
        result.addAnnotation(SdkPublicApi.class);
        result.addAnnotation(ThreadSafe.class);
        result.addAnnotation(Immutable.class);
        result.addMethods(this.waiterOperations());
        result.addSuperinterface(SdkAutoCloseable.class);
        result.addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc(WaiterDocs.waiterBuilderMethodJavadoc(this.className())).returns((TypeName)this.className().nestedClass("Builder")).addStatement("return $T.builder()", new Object[]{this.waiterImplName()}).build());
        result.addMethod(MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc(WaiterDocs.waiterCreateMethodJavadoc(this.className(), this.clientClassName())).returns((TypeName)this.className()).addStatement("return $T.builder().build()", new Object[]{this.waiterImplName()}).build());
        result.addJavadoc(WaiterDocs.waiterInterfaceJavadoc(), new Object[0]);
        result.addType(this.builderInterface());
        return result.build();
    }

    protected abstract ClassName waiterImplName();

    protected abstract ClassName clientClassName();

    protected abstract ParameterizedTypeName getWaiterResponseType(OperationModel var1);

    protected void additionalBuilderTypeSpecModification(TypeSpec.Builder type) {
    }

    private List<MethodSpec> waiterOperations() {
        return this.waiters.entrySet().stream().flatMap(this::waiterOperations).sorted(Comparator.comparing(m -> m.name)).collect(Collectors.toList());
    }

    private Stream<MethodSpec> waiterOperations(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.waiterOperation(waiterDefinition));
        methods.add(this.waiterConsumerBuilderOperation(waiterDefinition));
        methods.add(this.waiterOperationWithOverrideConfig(waiterDefinition));
        methods.add(this.waiterConsumerBuilderOperationWithOverrideConfig(waiterDefinition));
        return methods.stream();
    }

    private MethodSpec waiterOperation(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        String waiterMethodName = waiterDefinition.getKey();
        OperationModel opModel = this.model.getOperation(waiterDefinition.getValue().getOperation());
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        CodeBlock javadoc = WaiterDocs.waiterOperationJavadoc(this.clientClassName(), waiterDefinition, opModel);
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(waiterMethodName, opModel).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(javadoc);
        return this.unsupportedOperation(builder).build();
    }

    private MethodSpec waiterOperationWithOverrideConfig(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        String waiterMethodName = waiterDefinition.getKey();
        OperationModel opModel = this.model.getOperation(waiterDefinition.getValue().getOperation());
        ClassName requestClass = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        CodeBlock javadoc = WaiterDocs.waiterOperationWithOverrideConfig(this.clientClassName(), waiterDefinition, opModel);
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(waiterMethodName, opModel).addParameter((TypeName)requestClass, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(WaiterOverrideConfiguration.class), "overrideConfig", new Modifier[0]).addJavadoc(javadoc);
        return this.unsupportedOperation(builder).build();
    }

    private MethodSpec waiterConsumerBuilderOperationWithOverrideConfig(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        String waiterMethodName = waiterDefinition.getKey();
        OperationModel opModel = this.model.getOperation(waiterDefinition.getValue().getOperation());
        ClassName requestClass = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ParameterizedTypeName requestType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{requestClass.nestedClass("Builder")});
        ParameterizedTypeName overrideConfigType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(WaiterOverrideConfiguration.class).nestedClass("Builder")});
        CodeBlock javadoc = WaiterDocs.waiterOperationWithOverrideConfigConsumerBuilder(this.clientClassName(), waiterDefinition, opModel);
        String inputVariable = opModel.getInput().getVariableName();
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(waiterMethodName, opModel).addParameter((TypeName)requestType, inputVariable, new Modifier[0]).addParameter((TypeName)overrideConfigType, "overrideConfig", new Modifier[0]).addJavadoc(javadoc);
        builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("return $L($T.builder().applyMutation($L).build(),$T.builder().applyMutation($L).build())", new Object[]{this.getWaiterMethodName(waiterMethodName), requestClass, inputVariable, ClassName.get(WaiterOverrideConfiguration.class), "overrideConfig"});
        return builder.build();
    }

    private MethodSpec waiterConsumerBuilderOperation(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        String waiterMethodName = waiterDefinition.getKey();
        OperationModel opModel = this.model.getOperation(waiterDefinition.getValue().getOperation());
        ClassName requestClass = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ParameterizedTypeName requestType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{requestClass.nestedClass("Builder")});
        CodeBlock javadoc = WaiterDocs.waiterOperationConsumerBuilderJavadoc(this.clientClassName(), requestClass, waiterDefinition, opModel);
        String inputVariable = opModel.getInput().getVariableName();
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(waiterMethodName, opModel).addParameter((TypeName)requestType, inputVariable, new Modifier[0]).addJavadoc(javadoc);
        builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("return $L($T.builder().applyMutation($L).build())", new Object[]{this.getWaiterMethodName(waiterMethodName), requestClass, inputVariable});
        return builder.build();
    }

    private MethodSpec.Builder methodSignatureWithReturnType(String waiterMethodName, OperationModel opModel) {
        return MethodSpec.methodBuilder((String)this.getWaiterMethodName(waiterMethodName)).returns((TypeName)this.getWaiterResponseType(opModel));
    }

    private String getWaiterMethodName(String waiterMethodName) {
        return "waitUntil" + waiterMethodName;
    }

    private MethodSpec.Builder unsupportedOperation(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    private TypeSpec builderInterface() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        this.additionalBuilderTypeSpecModification(builder);
        builder.addMethods(this.builderMethods());
        return builder.build();
    }

    private List<MethodSpec> builderMethods() {
        ArrayList<MethodSpec> builderMethods = new ArrayList<MethodSpec>();
        builderMethods.add(MethodSpec.methodBuilder((String)"overrideConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ClassName.get(WaiterOverrideConfiguration.class), "overrideConfiguration", new Modifier[0]).addJavadoc(WaiterDocs.waiterBuilderPollingStrategy()).returns((TypeName)this.className().nestedClass("Builder")).build());
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(WaiterOverrideConfiguration.class).nestedClass("Builder")});
        builderMethods.add(MethodSpec.methodBuilder((String)"overrideConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)parameterizedTypeName, "overrideConfiguration", new Modifier[0]).addJavadoc(WaiterDocs.waiterBuilderPollingStrategyConsumerBuilder()).addStatement("$T.Builder builder = $T.builder()", new Object[]{WaiterOverrideConfiguration.class, WaiterOverrideConfiguration.class}).addStatement("overrideConfiguration.accept(builder)", new Object[0]).addStatement("return overrideConfiguration(builder.build())", new Object[0]).returns((TypeName)this.className().nestedClass("Builder")).build());
        builderMethods.add(MethodSpec.methodBuilder((String)"client").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)this.clientClassName(), "client", new Modifier[0]).addJavadoc(WaiterDocs.waiterBuilderClientJavadoc(this.clientClassName())).returns((TypeName)this.className().nestedClass("Builder")).build());
        builderMethods.add(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addJavadoc(WaiterDocs.waiterBuilderBuildJavadoc(this.className())).returns((TypeName)this.className()).build());
        return builderMethods;
    }
}

