/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.transform.MarshallerSpec;
import software.amazon.awssdk.utils.FunctionalUtils;

public class MarshallerGeneratorTasks
extends BaseGeneratorTasks {
    private final Metadata metadata;

    public MarshallerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.metadata = this.model.getMetadata();
    }

    @Override
    protected List<GeneratorTask> createTasks() {
        return this.model.getShapes().entrySet().stream().filter(e -> this.shouldGenerate((ShapeModel)e.getValue())).flatMap(FunctionalUtils.safeFunction(e -> this.createTask((ShapeModel)e.getValue()))).collect(Collectors.toList());
    }

    private boolean shouldGenerate(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingMarshaller()) {
            this.info("Skipping generating marshaller class for " + shapeModel.getShapeName());
            return false;
        }
        ShapeType shapeType = shapeModel.getShapeType();
        return (ShapeType.Request == shapeType || ShapeType.Model == shapeType && this.metadata.isJsonProtocol()) && !shapeModel.isEventStream();
    }

    private Stream<GeneratorTask> createTask(ShapeModel shapeModel) {
        return ShapeType.Request == shapeModel.getShapeType() || ShapeType.Model == shapeModel.getShapeType() && shapeModel.isEvent() && EventStreamUtils.isRequestEvent(this.model, shapeModel) ? Stream.of(this.createPoetGeneratorTask(new MarshallerSpec(this.model, shapeModel))) : Stream.empty();
    }
}

