/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.AuthorizerModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ServiceExamples;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.IoUtils;

public final class IntermediateModel {
    private static final String DEFAULT_CLIENT_CONFIG_FACTORY = "LegacyClientConfigurationFactory";
    private final Metadata metadata;
    private final Map<String, OperationModel> operations;
    private final Map<String, ShapeModel> shapes;
    private final CustomizationConfig customizationConfig;
    private final ServiceExamples examples;
    private final Map<String, AuthorizerModel> customAuthorizers;
    @JsonIgnore
    private final Optional<OperationModel> endpointOperation;
    @JsonIgnore
    private final Map<String, PaginatorDefinition> paginators;
    @JsonIgnore
    private final NamingStrategy namingStrategy;

    @JsonCreator
    public IntermediateModel(@JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="operations") Map<String, OperationModel> operations, @JsonProperty(value="shapes") Map<String, ShapeModel> shapes, @JsonProperty(value="customizationConfig") CustomizationConfig customizationConfig, @JsonProperty(value="serviceExamples") ServiceExamples examples) {
        this(metadata, operations, shapes, customizationConfig, examples, null, Collections.emptyMap(), Collections.emptyMap(), null);
    }

    public IntermediateModel(Metadata metadata, Map<String, OperationModel> operations, Map<String, ShapeModel> shapes, CustomizationConfig customizationConfig, ServiceExamples examples, OperationModel endpointOperation, Map<String, AuthorizerModel> customAuthorizers, Map<String, PaginatorDefinition> paginators, NamingStrategy namingStrategy) {
        this.metadata = metadata;
        this.operations = operations;
        this.shapes = shapes;
        this.customizationConfig = customizationConfig;
        this.examples = examples;
        this.endpointOperation = Optional.ofNullable(endpointOperation);
        this.customAuthorizers = customAuthorizers;
        this.paginators = paginators;
        this.namingStrategy = namingStrategy;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Map<String, OperationModel> getOperations() {
        return this.operations;
    }

    public OperationModel getOperation(String operationName) {
        return this.getOperations().get(operationName);
    }

    public Map<String, ShapeModel> getShapes() {
        return this.shapes;
    }

    public ShapeModel getShapeByC2jName(String c2jName) {
        return Utils.findShapeModelByC2jName(this, c2jName);
    }

    public CustomizationConfig getCustomizationConfig() {
        return this.customizationConfig;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public Map<String, PaginatorDefinition> getPaginators() {
        return this.paginators;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public String getCustomRetryPolicy() {
        return this.customizationConfig.getCustomRetryPolicy();
    }

    public String getSdkModeledExceptionBaseFqcn() {
        return String.format("%s.%s", this.metadata.getFullModelPackageName(), this.getSdkModeledExceptionBaseClassName());
    }

    public String getSdkModeledExceptionBaseClassName() {
        if (this.customizationConfig.getSdkModeledExceptionBaseClassName() != null) {
            return this.customizationConfig.getSdkModeledExceptionBaseClassName();
        }
        return this.metadata.getBaseExceptionName();
    }

    public String getSdkRequestBaseClassName() {
        if (this.customizationConfig.getSdkRequestBaseClassName() != null) {
            return this.customizationConfig.getSdkRequestBaseClassName();
        }
        return this.metadata.getBaseRequestName();
    }

    public String getSdkResponseBaseClassName() {
        if (this.customizationConfig.getSdkResponseBaseClassName() != null) {
            return this.customizationConfig.getSdkResponseBaseClassName();
        }
        return this.metadata.getBaseResponseName();
    }

    public String getFileHeader() throws IOException {
        return this.loadDefaultFileHeader();
    }

    private String loadDefaultFileHeader() throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/software/amazon/awssdk/codegen/DefaultFileHeader.txt");){
            String string = IoUtils.toUtf8String((InputStream)inputStream).replaceFirst("%COPYRIGHT_DATE_RANGE%", this.getCopyrightDateRange());
            return string;
        }
    }

    private String getCopyrightDateRange() {
        int currentYear = ZonedDateTime.now().getYear();
        int copyrightStartYear = currentYear - 5;
        return String.format("%d-%d", copyrightStartYear, currentYear);
    }

    public String getSdkBaseResponseFqcn() {
        if (this.metadata.getProtocol() == Protocol.API_GATEWAY) {
            return "software.amazon.awssdk.opensdk.BaseResult";
        }
        return String.format("%s<%s>", AwsResponse.class.getName(), this.getResponseMetadataClassName());
    }

    private String getResponseMetadataClassName() {
        return AwsResponseMetadata.class.getName();
    }

    @JsonIgnore
    public List<OperationModel> simpleMethodsRequiringTesting() {
        return this.getOperations().values().stream().filter(v -> v.getInputShape().isSimpleMethod()).filter(v -> !this.getCustomizationConfig().getVerifiedSimpleMethods().contains(v.getMethodName())).filter(v -> v.getMethodName().matches("(get|list|describe|lookup|batchGet).*")).collect(Collectors.toList());
    }

    public Map<String, AuthorizerModel> getCustomAuthorizers() {
        return this.customAuthorizers;
    }

    public Optional<OperationModel> getEndpointOperation() {
        return this.endpointOperation;
    }

    public boolean hasPaginators() {
        return this.paginators.size() > 0;
    }

    public boolean containsRequestSigners() {
        return this.getShapes().values().stream().filter(ShapeModel::isRequestSignerAware).findAny().isPresent();
    }

    public boolean containsRequestEventStreams() {
        return this.getOperations().values().stream().filter(opModel -> opModel.hasEventStreamInput()).findAny().isPresent();
    }
}

