/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform.protocols;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.poet.transform.protocols.CodegenSerializer;

public interface CodegenSerializerResolver {
    public static final CodegenSerializerResolver DEFAULT = new CodegenSerializerResolver(){

        @Override
        public <T> CodegenSerializer<T> serializerFor(T value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            Class<?> xclass = value.getClass();
            if (xclass == String.class) {
                return new CodegenSerializer.CodegenStringSerializer();
            }
            if (List.class.isAssignableFrom(xclass)) {
                return new CodegenSerializer.CodegenListSerializer(this);
            }
            if (Map.class.isAssignableFrom(xclass)) {
                return new CodegenSerializer.CodegenMapSerializer(this);
            }
            return new CodegenSerializer.CodegenLiteralSerializer();
        }
    };

    public static CodegenSerializerResolver getDefault() {
        return DEFAULT;
    }

    public <T> CodegenSerializer<T> serializerFor(T var1);
}

