/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AsyncAws4Signer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.client.handler.AwsClientHandlerUtils;
import software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionJsonMarshaller;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.config.customization.UtilitiesMethod;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientClass;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;
import software.amazon.awssdk.codegen.poet.model.ServiceClientConfigurationUtils;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.AsyncResponseTransformerUtils;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Pair;

public final class AsyncClientClass
extends AsyncClientInterface {
    private final IntermediateModel model;
    private final PoetExtension poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;
    private final ClassName serviceClientConfigurationClassName;
    private final ServiceClientConfigurationUtils configurationUtils;
    private final boolean useSraAuth;
    private boolean hasScheduledExecutor;

    public AsyncClientClass(GeneratorTaskParams dependencies) {
        super(dependencies.getModel());
        this.model = dependencies.getModel();
        this.poetExtensions = dependencies.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model);
        this.serviceClientConfigurationClassName = new PoetExtension(this.model).getServiceConfigClass();
        this.useSraAuth = new AuthSchemeSpecUtils(this.model).useSraAuth();
        this.configurationUtils = new ServiceClientConfigurationUtils(this.model);
    }

    @Override
    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createClassBuilder(this.className);
    }

    @Override
    protected void addInterfaceClass(TypeSpec.Builder type) {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
        type.addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass});
    }

    @Override
    protected void addAnnotations(TypeSpec.Builder type) {
        type.addAnnotation(SdkInternalApi.class);
    }

    @Override
    protected void addModifiers(TypeSpec.Builder type) {
        type.addModifiers(new Modifier[]{Modifier.FINAL});
    }

    @Override
    protected void addFields(TypeSpec.Builder type) {
        type.addField(FieldSpec.builder((TypeName)ClassName.get(Logger.class), (String)"log", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.getLogger($T.class)", new Object[]{LoggerFactory.class, this.className}).build()).addField(this.protocolMetadata()).addField(AsyncClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addField(SdkClientConfiguration.class, "clientConfiguration", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (this.model.getMetadata().isCborProtocol()) {
            type.addField(AwsJsonProtocolFactory.class, "jsonProtocolFactory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        }
        if (this.shouldAddScheduledExecutor()) {
            this.addScheduledExecutorIfNeeded(type);
        }
        this.model.getEndpointOperation().ifPresent(o -> type.addField(EndpointDiscoveryRefreshCache.class, "endpointDiscoveryCache", new Modifier[]{Modifier.PRIVATE}));
    }

    @Override
    protected void addAdditionalMethods(TypeSpec.Builder type) {
        type.addMethod(this.constructor(type)).addMethod(this.nameMethod()).addMethods(this.protocolSpec.additionalMethods()).addMethod(this.protocolSpec.initProtocolFactory(this.model)).addMethod(this.resolveMetricPublishersMethod());
        if (!this.useSraAuth && (this.model.containsRequestSigners() || this.model.containsRequestEventStreams() || this.hasStreamingV4AuthOperations())) {
            type.addMethod(ClientClassUtils.applySignerOverrideMethod(this.poetExtensions, this.model));
            type.addMethod(this.isSignerOverriddenOnClientMethod());
        }
        type.addMethod(ClientClassUtils.updateRetryStrategyClientConfigurationMethod());
        type.addMethod(AsyncClientClass.updateSdkClientConfigurationMethod((TypeName)this.configurationUtils.serviceClientConfigurationBuilderClassName()));
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)type).addMethod(arg_0));
        this.protocolSpec.createEventstreamErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)type).addMethod(arg_0));
    }

    @Override
    protected void addWaiterMethod(TypeSpec.Builder type) {
        MethodSpec waiter = MethodSpec.methodBuilder((String)"waiter").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return $T.builder().client(this).scheduledExecutorService(executorService).build()", new Object[]{this.poetExtensions.getAsyncWaiterInterface()}).returns((TypeName)this.poetExtensions.getAsyncWaiterInterface()).build();
        type.addMethod(waiter);
    }

    protected List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().flatMap(this::operations).sorted(Comparator.comparing(m -> m.name)).collect(Collectors.toList());
    }

    private Stream<MethodSpec> operations(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.traditionalMethod(opModel));
        return methods.stream();
    }

    private FieldSpec protocolMetadata() {
        return FieldSpec.builder(AwsProtocolMetadata.class, (String)"protocolMetadata", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.builder().serviceProtocol($T.$L).build()", new Object[]{AwsProtocolMetadata.class, AwsServiceProtocol.class, this.model.getMetadata().getProtocol()}).build();
    }

    private MethodSpec constructor(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SdkClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration)", new Object[]{AwsAsyncClientHandler.class}).addStatement("this.clientConfiguration = clientConfiguration.toBuilder().option($T.SDK_CLIENT, this).build()", new Object[]{SdkClientOption.class});
        FieldSpec protocolFactoryField = this.protocolSpec.protocolFactory(this.model);
        if (this.model.getMetadata().isJsonProtocol()) {
            builder.addStatement("this.$N = init($T.builder()).build()", new Object[]{protocolFactoryField.name, protocolFactoryField.type});
        } else {
            builder.addStatement("this.$N = init()", new Object[]{protocolFactoryField.name});
        }
        if (this.model.getMetadata().isCborProtocol()) {
            builder.addStatement("this.jsonProtocolFactory = init($T.builder()).build()", new Object[]{AwsJsonProtocolFactory.class});
        }
        if (this.hasOperationWithEventStreamOutput()) {
            classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(Executor.class), (String)"executor", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builder.addStatement("this.executor = clientConfiguration.option($T.FUTURE_COMPLETION_EXECUTOR)", new Object[]{SdkAdvancedAsyncClientOption.class});
        }
        if (this.model.getEndpointOperation().isPresent()) {
            builder.beginControlFlow("if (clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED))", new Object[0]);
            builder.addStatement("this.endpointDiscoveryCache = $T.create($T.create(this))", new Object[]{EndpointDiscoveryRefreshCache.class, this.poetExtensions.getClientClass(this.model.getNamingStrategy().getServiceName() + "AsyncEndpointDiscoveryCacheLoader")});
            if (this.model.getCustomizationConfig().allowEndpointOverrideForEndpointDiscoveryRequiredOperations()) {
                builder.beginControlFlow("if (clientConfiguration.option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER).isEndpointOverridden())", new Object[0]);
                builder.addStatement("log.warn($S)", new Object[]{"Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended."});
                builder.endControlFlow();
            }
            builder.endControlFlow();
        }
        if (this.shouldAddScheduledExecutor()) {
            builder.addStatement("this.executorService = clientConfiguration.option($T.SCHEDULED_EXECUTOR_SERVICE)", new Object[]{SdkClientOption.class});
        }
        return builder.build();
    }

    private boolean shouldAddScheduledExecutor() {
        return this.model.hasWaiters() || this.model.getCustomizationConfig().getBatchManagerSupported();
    }

    private boolean hasOperationWithEventStreamOutput() {
        return this.model.getOperations().values().stream().anyMatch(OperationModel::hasEventStreamOutput);
    }

    private MethodSpec nameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return SERVICE_NAME", new Object[0]).build();
    }

    @Override
    protected MethodSpec serviceClientConfigMethod() {
        return MethodSpec.methodBuilder((String)"serviceClientConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)this.serviceClientConfigurationClassName).addStatement("return new $T(this.clientConfiguration.toBuilder()).build()", new Object[]{this.configurationUtils.serviceClientConfigurationBuilderClassName()}).build();
    }

    protected static MethodSpec updateSdkClientConfigurationMethod(TypeName serviceClientConfigurationBuilderClassName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"updateSdkClientConfiguration").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(SdkRequest.class, "request", new Modifier[0]).addParameter(SdkClientConfiguration.class, "clientConfiguration", new Modifier[0]).returns(SdkClientConfiguration.class);
        builder.addStatement("$T plugins = request.overrideConfiguration()\n.map(c -> c.plugins()).orElse(Collections.emptyList())", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{SdkPlugin.class})}).addStatement("$T configuration = clientConfiguration.toBuilder()", new Object[]{SdkClientConfiguration.Builder.class});
        builder.beginControlFlow("if (plugins.isEmpty())", new Object[0]).addStatement("return configuration.build()", new Object[0]).endControlFlow().addStatement("$1T serviceConfigBuilder = new $1T(configuration)", new Object[]{serviceClientConfigurationBuilderClassName}).beginControlFlow("for ($T plugin : plugins)", new Object[]{SdkPlugin.class}).addStatement("plugin.configureClient(serviceConfigBuilder)", new Object[0]).endControlFlow();
        builder.addStatement("updateRetryStrategyClientConfiguration(configuration)", new Object[0]);
        builder.addStatement("return configuration.build()", new Object[0]);
        return builder.build();
    }

    @Override
    protected void addCloseMethod(TypeSpec.Builder type) {
        MethodSpec method = MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$N.close()", new Object[]{"clientHandler"}).build();
        type.addMethod(method);
    }

    @Override
    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        ClassName responseType;
        SyncClientClass.addRequestModifierCode(opModel, this.model).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addCode(arg_0));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
        builder.addStatement("$T clientConfiguration = updateSdkClientConfiguration($L, this.clientConfiguration)", new Object[]{SdkClientConfiguration.class, opModel.getInput().getVariableName()});
        builder.addStatement("$T<$T> metricPublishers = resolveMetricPublishers(clientConfiguration, $N.overrideConfiguration().orElse(null))", new Object[]{List.class, MetricPublisher.class, opModel.getInput().getVariableName()}).addStatement("$1T apiCallMetricCollector = metricPublishers.isEmpty() ? $2T.create() : $1T.create($3S)", new Object[]{MetricCollector.class, NoOpMetricCollector.class, "ApiCall"});
        builder.beginControlFlow("try", new Object[0]);
        builder.addStatement("apiCallMetricCollector.reportMetric($T.$L, $S)", new Object[]{CoreMetric.class, "SERVICE_ID", this.model.getMetadata().getServiceId()});
        builder.addStatement("apiCallMetricCollector.reportMetric($T.$L, $S)", new Object[]{CoreMetric.class, "OPERATION_NAME", opModel.getOperationName()});
        if (opModel.hasStreamingOutput()) {
            responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
            builder.addStatement("$T<$T<$T, ReturnT>, $T<$T>> $N = $T.wrapWithEndOfStreamFuture($N)", new Object[]{Pair.class, AsyncResponseTransformer.class, responseType, CompletableFuture.class, Void.class, "pair", AsyncResponseTransformerUtils.class, "asyncResponseTransformer"});
            builder.addStatement("$N = $N.left()", new Object[]{"asyncResponseTransformer", "pair"});
            builder.addStatement("$T<$T> $N = $N.right()", new Object[]{CompletableFuture.class, Void.class, "endOfStreamFuture", "pair"});
        }
        if (!this.useSraAuth) {
            if (this.shouldUseAsyncWithBodySigner(opModel)) {
                builder.addCode(this.applyAsyncWithBodyV4SignerOverride(opModel));
            } else {
                builder.addCode(ClientClassUtils.callApplySignerOverrideMethod(opModel));
            }
        }
        builder.addCode(this.protocolSpec.responseHandler(this.model, opModel));
        this.protocolSpec.errorResponseHandler(opModel).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addCode(arg_0));
        builder.addCode(this.eventToByteBufferPublisher(opModel));
        if (opModel.getEndpointDiscovery() != null) {
            builder.addStatement("boolean endpointDiscoveryEnabled = clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)", new Object[0]);
            builder.addStatement("boolean endpointOverridden = clientConfiguration.option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER).isEndpointOverridden()", new Object[0]);
            if (opModel.getEndpointDiscovery().isRequired()) {
                if (!this.model.getCustomizationConfig().allowEndpointOverrideForEndpointDiscoveryRequiredOperations()) {
                    builder.beginControlFlow("if (endpointOverridden)", new Object[0]);
                    builder.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery, but an endpoint override was specified when the client was created. This is not supported."});
                    builder.endControlFlow();
                    builder.beginControlFlow("if (!endpointDiscoveryEnabled)", new Object[0]);
                    builder.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery, but endpoint discovery was disabled on the client."});
                    builder.endControlFlow();
                } else {
                    builder.beginControlFlow("if (endpointOverridden)", new Object[0]);
                    builder.addStatement("endpointDiscoveryEnabled = false", new Object[0]);
                    builder.nextControlFlow("else if (!endpointDiscoveryEnabled)", new Object[0]);
                    builder.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created."});
                    builder.endControlFlow();
                }
            }
            builder.addStatement("$T<$T> endpointFuture = $T.completedFuture(null)", new Object[]{CompletableFuture.class, URI.class, CompletableFuture.class});
            builder.beginControlFlow("if (endpointDiscoveryEnabled)", new Object[0]);
            ParameterizedTypeName identityFutureTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(AwsCredentialsIdentity.class)});
            builder.addCode("$T identityFuture = $N.overrideConfiguration()", new Object[]{identityFutureTypeName, opModel.getInput().getVariableName()}).addCode("    .flatMap($T::credentialsIdentityProvider)", new Object[]{AwsRequestOverrideConfiguration.class}).addCode("    .orElseGet(() -> clientConfiguration.option($T.CREDENTIALS_IDENTITY_PROVIDER))", new Object[]{AwsClientOption.class}).addCode("    .resolveIdentity();", new Object[0]);
            builder.addCode("endpointFuture = identityFuture.thenCompose(credentials -> {", new Object[0]).addCode("    $1T endpointDiscoveryRequest = $1T.builder()", new Object[]{EndpointDiscoveryRequest.class}).addCode("        .required($L)", new Object[]{opModel.getInputShape().getEndpointDiscovery().isRequired()}).addCode("        .defaultEndpoint(clientConfiguration.option($T.CLIENT_ENDPOINT_PROVIDER).clientEndpoint())", new Object[]{SdkClientOption.class}).addCode("        .overrideConfiguration($N.overrideConfiguration().orElse(null))", new Object[]{opModel.getInput().getVariableName()}).addCode("        .build();", new Object[0]).addCode("    return endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);", new Object[0]).addCode("});", new Object[0]);
            builder.endControlFlow();
        }
        ClientClassUtils.addS3ArnableFieldCode(opModel, this.model).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addCode(arg_0));
        builder.addCode(ClientClassUtils.addEndpointTraitCode(opModel));
        builder.addCode(this.protocolSpec.asyncExecutionHandler(this.model, opModel)).endControlFlow().beginControlFlow("catch ($T t)", new Object[]{Throwable.class});
        if (opModel.hasStreamingOutput()) {
            responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
            builder.addStatement("$T<$T, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer", new Object[]{AsyncResponseTransformer.class, responseType});
        }
        if (opModel.hasStreamingOutput() || opModel.hasEventStreamOutput()) {
            String paramName = opModel.hasStreamingOutput() ? "finalAsyncResponseTransformer" : "asyncResponseHandler";
            builder.addStatement("runAndLogError(log, \"Exception thrown in exceptionOccurred callback, ignoring\",\n() -> $N.exceptionOccurred(t))", new Object[]{paramName});
        }
        builder.addStatement("metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()))", new Object[0]).addStatement("return $T.failedFuture(t)", new Object[]{CompletableFutureUtils.class}).endControlFlow();
        return builder;
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        return Collections.singletonList(StaticImport.staticMethodImport(FunctionalUtils.class, "runAndLogError"));
    }

    private CodeBlock eventToByteBufferPublisher(OperationModel opModel) {
        if (!opModel.hasEventStreamInput()) {
            return CodeBlock.builder().build();
        }
        ShapeModel eventStreamShape = EventStreamUtils.getEventStreamInRequest(opModel.getInputShape());
        CodeBlock code = CodeBlock.builder().add(this.createEventStreamTaggedUnionJsonMarshaller(eventStreamShape)).addStatement("$1T eventPublisher = $2T.adapt($3L)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(SdkPublisher.class), (TypeName[])new TypeName[]{this.eventStreamType(eventStreamShape)}), SdkPublisher.class, "requestStream"}).add("$T adapted = eventPublisher.map(event -> eventMarshaller.marshall(event))", new Object[]{ParameterizedTypeName.get(Publisher.class, (Type[])new Type[]{ByteBuffer.class})}).add(".map($T::encodeEventStreamRequestToByteBuffer);", new Object[]{AwsClientHandlerUtils.class}).build();
        return code;
    }

    private CodeBlock createEventStreamTaggedUnionJsonMarshaller(ShapeModel eventStreamShape) {
        EventStreamSpecHelper specHelper = new EventStreamSpecHelper(eventStreamShape, this.model);
        CodeBlock.Builder builder = CodeBlock.builder().add("$1T eventMarshaller = $1T.builder()", new Object[]{EventStreamTaggedUnionJsonMarshaller.class});
        List<MemberModel> eventMembers = EventStreamUtils.getEventMembers(eventStreamShape).collect(Collectors.toList());
        eventMembers.forEach(event -> builder.add(".putMarshaller($T.class, new $T(protocolFactory))", new Object[]{specHelper.eventClassName((MemberModel)event), this.poetExtensions.getTransformClass(event.getShape() + "Marshaller")}));
        builder.add(".build();", new Object[0]);
        return builder.build();
    }

    private TypeName eventStreamType(ShapeModel shapeModel) {
        return this.poetExtensions.getModelClass(shapeModel.getShapeName());
    }

    @Override
    protected MethodSpec utilitiesMethod() {
        UtilitiesMethod config = this.model.getCustomizationConfig().getUtilitiesMethod();
        ClassName returnType = PoetUtils.classNameFromFqcn(config.getReturnType());
        String instanceClass = config.getInstanceType();
        if (instanceClass == null) {
            instanceClass = config.getReturnType();
        }
        ClassName instanceType = PoetUtils.classNameFromFqcn(instanceClass);
        return MethodSpec.methodBuilder((String)"utilities").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return $T.create($L)", new Object[]{instanceType, String.join((CharSequence)",", config.getCreateMethodParams())}).build();
    }

    @Override
    protected void addBatchManagerMethod(TypeSpec.Builder type) {
        String scheduledExecutor = "executorService";
        ClassName returnType = this.poetExtensions.getBatchManagerAsyncInterface();
        MethodSpec batchManager = MethodSpec.methodBuilder((String)"batchManager").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)returnType).addStatement("return $T.builder().client(this).scheduledExecutor($N).build()", new Object[]{returnType, scheduledExecutor}).build();
        type.addMethod(batchManager);
    }

    private MethodSpec resolveMetricPublishersMethod() {
        String clientConfigName = "clientConfiguration";
        String requestOverrideConfigName = "requestOverrideConfiguration";
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"resolveMetricPublishers").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{MetricPublisher.class})).addParameter(SdkClientConfiguration.class, clientConfigName, new Modifier[0]).addParameter(RequestOverrideConfiguration.class, requestOverrideConfigName, new Modifier[0]);
        String publishersName = "publishers";
        methodBuilder.addStatement("$T $N = null", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{MetricPublisher.class}), publishersName});
        methodBuilder.beginControlFlow("if ($N != null)", new Object[]{requestOverrideConfigName}).addStatement("$N = $N.metricPublishers()", new Object[]{publishersName, requestOverrideConfigName}).endControlFlow();
        methodBuilder.beginControlFlow("if ($1N == null || $1N.isEmpty())", new Object[]{publishersName}).addStatement("$N = $N.option($T.$N)", new Object[]{publishersName, clientConfigName, SdkClientOption.class, "METRIC_PUBLISHERS"}).endControlFlow();
        methodBuilder.beginControlFlow("if ($1N == null)", new Object[]{publishersName}).addStatement("$N = $T.emptyList()", new Object[]{publishersName, Collections.class}).endControlFlow();
        methodBuilder.addStatement("return $N", new Object[]{publishersName});
        return methodBuilder.build();
    }

    private boolean shouldUseAsyncWithBodySigner(OperationModel opModel) {
        if (opModel.getInputShape().getRequestSignerClassFqcn() != null) {
            return false;
        }
        AuthType authTypeForOperation = opModel.getAuthType();
        if (authTypeForOperation == null) {
            authTypeForOperation = this.model.getMetadata().getAuthType();
        }
        return authTypeForOperation == AuthType.V4 && opModel.hasStreamingInput();
    }

    private CodeBlock applyAsyncWithBodyV4SignerOverride(OperationModel opModel) {
        return CodeBlock.builder().beginControlFlow("if (!isSignerOverridden($N))", new Object[]{"clientConfiguration"}).addStatement("$1L = applySignerOverride($1L, $2T.create())", new Object[]{opModel.getInput().getVariableName(), AsyncAws4Signer.class}).endControlFlow().build();
    }

    private MethodSpec isSignerOverriddenOnClientMethod() {
        String clientConfigurationName = "clientConfiguration";
        return MethodSpec.methodBuilder((String)"isSignerOverridden").returns(Boolean.TYPE).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(SdkClientConfiguration.class, clientConfigurationName, new Modifier[0]).addStatement("return $T.TRUE.equals($N.option($T.$N))", new Object[]{Boolean.class, clientConfigurationName, SdkClientOption.class, "SIGNER_OVERRIDDEN"}).build();
    }

    private boolean hasStreamingV4AuthOperations() {
        return this.model.getOperations().values().stream().anyMatch(this::shouldUseAsyncWithBodySigner);
    }

    private void addScheduledExecutorIfNeeded(TypeSpec.Builder classBuilder) {
        if (!this.hasScheduledExecutor) {
            classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(ScheduledExecutorService.class), (String)"executorService", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            this.hasScheduledExecutor = true;
        }
    }
}

