/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.utils.AuthUtils;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;

public final class AuthSchemeSpecUtils {
    private static final Set<String> DEFAULT_AUTH_SCHEME_PARAMS = AuthSchemeSpecUtils.setOf("region", "operation");
    private final IntermediateModel intermediateModel;
    private final boolean useSraAuth;
    private final Set<String> allowedEndpointAuthSchemeParams;
    private final boolean allowedEndpointAuthSchemeParamsConfigured;

    public AuthSchemeSpecUtils(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        CustomizationConfig customization = intermediateModel.getCustomizationConfig();
        this.useSraAuth = customization.useSraAuth();
        if (customization.getAllowedEndpointAuthSchemeParamsConfigured()) {
            this.allowedEndpointAuthSchemeParams = Collections.unmodifiableSet(new HashSet<String>(customization.getAllowedEndpointAuthSchemeParams()));
            this.allowedEndpointAuthSchemeParamsConfigured = true;
        } else {
            this.allowedEndpointAuthSchemeParams = Collections.emptySet();
            this.allowedEndpointAuthSchemeParamsConfigured = false;
        }
    }

    public boolean useSraAuth() {
        return this.useSraAuth;
    }

    private String basePackage() {
        return this.intermediateModel.getMetadata().getFullAuthSchemePackageName();
    }

    private String internalPackage() {
        return this.intermediateModel.getMetadata().getFullInternalAuthSchemePackageName();
    }

    public String baseClientPackageName() {
        return this.intermediateModel.getMetadata().getFullClientPackageName();
    }

    public ClassName parametersInterfaceName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "AuthSchemeParams"), (String[])new String[0]);
    }

    public ClassName parametersEndpointAwareDefaultImplName() {
        return ClassName.get((String)this.internalPackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "EndpointResolverAware"), (String[])new String[0]);
    }

    public ClassName parametersInterfaceBuilderInterfaceName() {
        return this.parametersInterfaceName().nestedClass("Builder");
    }

    public ClassName parametersDefaultImplName() {
        return ClassName.get((String)this.internalPackage(), (String)("Default" + this.parametersInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName parametersDefaultBuilderImplName() {
        return ClassName.get((String)this.internalPackage(), (String)("Default" + this.parametersInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName providerInterfaceName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "AuthSchemeProvider"), (String[])new String[0]);
    }

    public ClassName defaultAuthSchemeProviderName() {
        return ClassName.get((String)this.internalPackage(), (String)("Default" + this.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName modeledAuthSchemeProviderName() {
        return ClassName.get((String)this.internalPackage(), (String)("Modeled" + this.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName authSchemeInterceptor() {
        return ClassName.get((String)this.internalPackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "AuthSchemeInterceptor"), (String[])new String[0]);
    }

    public TypeName resolverReturnType() {
        return ParameterizedTypeName.get(List.class, (Type[])new Type[]{AuthSchemeOption.class});
    }

    public boolean usesSigV4() {
        return AuthUtils.usesAwsAuth(this.intermediateModel);
    }

    public boolean useEndpointBasedAuthProvider() {
        return this.generateEndpointBasedParams();
    }

    public String paramMethodName(String name) {
        return this.intermediateModel.getNamingStrategy().getVariableName(name);
    }

    public boolean generateEndpointBasedParams() {
        return this.intermediateModel.getCustomizationConfig().isEnableEndpointAuthSchemeParams();
    }

    public boolean includeParam(String name) {
        if (this.allowedEndpointAuthSchemeParamsConfigured) {
            return this.allowedEndpointAuthSchemeParams.contains(name);
        }
        return !DEFAULT_AUTH_SCHEME_PARAMS.contains(name.toLowerCase(Locale.US));
    }

    public boolean includeParamForProvider(String name) {
        if (this.allowedEndpointAuthSchemeParamsConfigured) {
            if (DEFAULT_AUTH_SCHEME_PARAMS.contains(name.toLowerCase(Locale.US))) {
                return true;
            }
            return this.allowedEndpointAuthSchemeParams.contains(name);
        }
        return true;
    }

    public String serviceName() {
        return this.intermediateModel.getMetadata().getServiceName();
    }

    public String signingName() {
        return this.intermediateModel.getMetadata().getSigningName();
    }

    private static Set<String> setOf(String val1, String val2) {
        HashSet<String> result = new HashSet<String>();
        result.add(val1);
        result.add(val2);
        return Collections.unmodifiableSet(result);
    }
}

