/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.document.Document;

public class TypeProvider {
    private final IntermediateModel intermediateModel;
    private final PoetExtension poetExtensions;

    public TypeProvider(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.poetExtensions = new PoetExtension(this.intermediateModel);
    }

    public ClassName listImplClassName() {
        return ClassName.get(ArrayList.class);
    }

    public TypeName enumReturnType(MemberModel memberModel) {
        return this.typeName(memberModel, new TypeNameOptions().useEnumTypes(true));
    }

    public TypeName returnType(MemberModel memberModel) {
        return this.typeName(memberModel, new TypeNameOptions().useEnumTypes(false));
    }

    public TypeName fieldType(MemberModel memberModel) {
        return this.typeName(memberModel, new TypeNameOptions().useEnumTypes(false));
    }

    public TypeName parameterType(MemberModel memberModel) {
        return this.parameterType(memberModel, false);
    }

    public TypeName parameterType(MemberModel memberModel, boolean preserveEnum) {
        return this.typeName(memberModel, new TypeNameOptions().useCollectionForList(true).useSubtypeWildcardsForCollections(true).useEnumTypes(preserveEnum));
    }

    public TypeName mapEntryWithConcreteTypes(MapModel mapModel) {
        TypeName keyType = this.fieldType(mapModel.getKeyModel());
        TypeName valueType = this.fieldType(mapModel.getValueModel());
        return ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{keyType, valueType});
    }

    public TypeName getTypeNameForSimpleType(String simpleType) {
        return (TypeName)Stream.of(String.class, Boolean.class, Integer.class, Long.class, Short.class, Byte.class, BigInteger.class, Double.class, Float.class, BigDecimal.class, SdkBytes.class, InputStream.class, Instant.class, Document.class).filter(cls -> cls.getName().equals(simpleType) || cls.getSimpleName().equals(simpleType)).map(ClassName::get).findFirst().orElseThrow(() -> new RuntimeException("Unsupported simple fieldType " + simpleType));
    }

    public FieldSpec asField(MemberModel memberModel, Modifier ... modifiers) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.fieldType(memberModel), (String)memberModel.getVariable().getVariableName(), (Modifier[])new Modifier[0]);
        if (modifiers != null) {
            builder.addModifiers(modifiers);
        }
        return builder.build();
    }

    private static boolean isContainerType(MemberModel m) {
        return m.isList() || m.isMap();
    }

    public TypeName typeName(MemberModel model) {
        return this.typeName(model, new TypeNameOptions());
    }

    public TypeName typeName(MemberModel model, TypeNameOptions options) {
        if (model.isSdkBytesType() && options.useByteBufferTypes) {
            return ClassName.get(ByteBuffer.class);
        }
        if (model.getEnumType() != null && options.useEnumTypes) {
            return this.poetExtensions.getModelClass(model.getEnumType());
        }
        if (model.isSimple()) {
            return this.getTypeNameForSimpleType(model.getVariable().getVariableType());
        }
        if (model.isList()) {
            MemberModel entryModel = model.getListModel().getListMemberModel();
            TypeName entryType = this.typeName(entryModel, options);
            if (options.useSubtypeWildcardsForCollections && TypeProvider.isContainerType(entryModel) || options.useSubtypeWildcardsForBuilders && entryModel.hasBuilder()) {
                entryType = WildcardTypeName.subtypeOf((TypeName)entryType);
            }
            Class collectionType = options.useCollectionForList ? Collection.class : List.class;
            return ParameterizedTypeName.get((ClassName)ClassName.get(collectionType), (TypeName[])new TypeName[]{entryType});
        }
        if (model.isMap()) {
            MemberModel keyModel = model.getMapModel().getKeyModel();
            MemberModel valueModel = model.getMapModel().getValueModel();
            TypeName keyType = this.typeName(keyModel, options);
            TypeName valueType = this.typeName(valueModel, options);
            if (options.useSubtypeWildcardsForCollections && TypeProvider.isContainerType(keyModel) || options.useSubtypeWildcardsForBuilders && keyModel.hasBuilder()) {
                keyType = WildcardTypeName.subtypeOf((TypeName)keyType);
            }
            if (options.useSubtypeWildcardsForCollections && TypeProvider.isContainerType(valueModel) || options.useSubtypeWildcardsForBuilders && valueModel.hasBuilder()) {
                valueType = WildcardTypeName.subtypeOf((TypeName)valueType);
            }
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType});
        }
        if (model.hasBuilder()) {
            ClassName shapeClass = this.poetExtensions.getModelClass(model.getC2jShape());
            switch (options.shapeTransformation) {
                case NONE: {
                    return shapeClass;
                }
                case USE_BUILDER: {
                    return shapeClass.nestedClass("Builder");
                }
                case USE_BUILDER_IMPL: {
                    return shapeClass.nestedClass("BuilderImpl");
                }
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException("Unsupported member model: " + model);
    }

    public static final class TypeNameOptions {
        private ShapeTransformation shapeTransformation = ShapeTransformation.NONE;
        private boolean useCollectionForList = false;
        private boolean useSubtypeWildcardsForCollections = false;
        private boolean useByteBufferTypes = false;
        private boolean useEnumTypes = false;
        private boolean useSubtypeWildcardsForBuilders = false;

        public TypeNameOptions shapeTransformation(ShapeTransformation shapeTransformation) {
            this.shapeTransformation = shapeTransformation;
            return this;
        }

        public TypeNameOptions useCollectionForList(boolean useCollectionForList) {
            this.useCollectionForList = useCollectionForList;
            return this;
        }

        public TypeNameOptions useSubtypeWildcardsForCollections(boolean useSubtypeWildcardsForCollections) {
            this.useSubtypeWildcardsForCollections = useSubtypeWildcardsForCollections;
            return this;
        }

        public TypeNameOptions useSubtypeWildcardsForBuilders(boolean useSubtypeWildcardsForBuilders) {
            this.useSubtypeWildcardsForBuilders = useSubtypeWildcardsForBuilders;
            return this;
        }

        public TypeNameOptions useEnumTypes(boolean useEnumTypes) {
            this.useEnumTypes = useEnumTypes;
            return this;
        }

        public TypeNameOptions useByteBufferTypes(boolean useByteBufferTypes) {
            this.useByteBufferTypes = useByteBufferTypes;
            return this;
        }
    }

    public static enum ShapeTransformation {
        USE_BUILDER,
        USE_BUILDER_IMPL,
        NONE;

    }
}

