/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.Map;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.ErrorMap;
import software.amazon.awssdk.codegen.model.service.Input;
import software.amazon.awssdk.codegen.model.service.Member;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.Output;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;

public class RenameShapesProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, String> renameShapes;

    public RenameShapesProcessor(Map<String, String> renameShapes) {
        this.renameShapes = renameShapes;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        String newName;
        String originalName;
        if (this.renameShapes == null || this.renameShapes.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : this.renameShapes.entrySet()) {
            originalName = entry.getKey();
            newName = entry.getValue();
            Shape originalShape = serviceModel.getShapes().get(originalName);
            if (originalShape == null) {
                throw new IllegalStateException(String.format("Cannot find shape [%s] in the model when processing customization config renameShapes.%s", originalName, originalName));
            }
            if (!serviceModel.getShapes().containsKey(newName)) continue;
            throw new IllegalStateException(String.format("The shape [%s] for the new name is already in the model when processing customization config renameShapes.%s", newName, originalName));
        }
        for (Map.Entry<String, Object> entry : serviceModel.getShapes().entrySet()) {
            String shapeName = entry.getKey();
            Shape shape = (Shape)entry.getValue();
            this.preprocessRenameMemberShapes(shape);
        }
        for (Operation operation : serviceModel.getOperations().values()) {
            if (operation.getInput() != null) {
                this.preprocessRenameInputShape(operation.getInput());
            }
            if (operation.getOutput() != null) {
                this.preprocessRenameOutputShape(operation.getOutput());
            }
            if (operation.getErrors() == null) continue;
            for (ErrorMap error : operation.getErrors()) {
                this.preprocessRenameErrorShape(error);
            }
        }
        for (Map.Entry entry : this.renameShapes.entrySet()) {
            originalName = (String)entry.getKey();
            newName = (String)entry.getValue();
            Shape shape = serviceModel.getShapes().remove(originalName);
            serviceModel.getShapes().put(newName, shape);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }

    private void preprocessRenameMemberShapes(Shape shape) {
        if (shape.getListMember() != null) {
            this.preprocessRenameMemberShape(shape.getListMember());
        }
        if (shape.getMapKeyType() != null) {
            this.preprocessRenameMemberShape(shape.getMapKeyType());
        }
        if (shape.getMapValueType() != null) {
            this.preprocessRenameMemberShape(shape.getMapValueType());
        }
        if (shape.getMembers() != null) {
            for (Map.Entry<String, Member> entry : shape.getMembers().entrySet()) {
                this.preprocessRenameMemberShape(entry.getValue());
            }
        }
    }

    private void preprocessRenameMemberShape(Member member) {
        if (this.renameShapes.containsKey(member.getShape())) {
            member.setShape(this.renameShapes.get(member.getShape()));
        }
    }

    private void preprocessRenameErrorShape(ErrorMap error) {
        if (this.renameShapes.containsKey(error.getShape())) {
            error.setShape(this.renameShapes.get(error.getShape()));
        }
    }

    private void preprocessRenameOutputShape(Output output) {
        if (this.renameShapes.containsKey(output.getShape())) {
            output.setShape(this.renameShapes.get(output.getShape()));
        }
    }

    private void preprocessRenameInputShape(Input input) {
        if (this.renameShapes.containsKey(input.getShape())) {
            input.setShape(this.renameShapes.get(input.getShape()));
        }
    }
}

