/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.SimpleGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

public final class RulesEngineRuntimeGeneratorTask2
extends BaseGeneratorTasks {
    private final String engineInternalClassDir;
    private final String engineInternalPackageName;
    private final String fileHeader;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public RulesEngineRuntimeGeneratorTask2(GeneratorTaskParams generatorTaskParams) {
        super(generatorTaskParams);
        this.engineInternalClassDir = generatorTaskParams.getPathProvider().getEndpointRulesInternalDirectory();
        this.engineInternalPackageName = generatorTaskParams.getModel().getMetadata().getFullInternalEndpointRulesPackageName();
        this.fileHeader = generatorTaskParams.getModel().getFileHeader();
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(generatorTaskParams.getModel());
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> copyTasks = new ArrayList<GeneratorTask>();
        List<String> rulesEngineFiles = this.endpointRulesSpecUtils.rulesEngineResourceFiles2();
        for (String path : this.rulesEngineJavaFilePaths(rulesEngineFiles)) {
            String newFileName = this.computeNewName(path);
            copyTasks.add(new SimpleGeneratorTask(this.engineInternalClassDir, newFileName, this.fileHeader, () -> this.rulesEngineFileContent("/" + path)));
        }
        return copyTasks;
    }

    private List<String> rulesEngineJavaFilePaths(Collection<String> runtimeEngineFiles) {
        return runtimeEngineFiles.stream().filter(e -> e.endsWith(".java.resource")).collect(Collectors.toList());
    }

    private String rulesEngineFileContent(String path) {
        return "package " + this.engineInternalPackageName + ";\n\n" + this.loadResourceAsString(path);
    }

    private String loadResourceAsString(String path) {
        try {
            return IoUtils.toUtf8String((InputStream)this.loadResource(path));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InputStream loadResource(String name) {
        InputStream resourceAsStream = RulesEngineRuntimeGeneratorTask2.class.getResourceAsStream(name);
        Validate.notNull((Object)resourceAsStream, (String)"Failed to load resource from %s", (Object[])new Object[]{name});
        return resourceAsStream;
    }

    private String computeNewName(String path) {
        String[] pathComponents = path.split("/");
        return StringUtils.replace((String)pathComponents[pathComponents.length - 1], (String)".resource", (String)"");
    }
}

