/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.docs;

import com.squareup.javapoet.ClassName;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.docs.DocConfiguration;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.docs.PaginationDocs;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

abstract class OperationDocProvider {
    static final String SIMPLE_FILE_INPUT_DOCS = "{@link Path} to file containing data to send to the service. File will be read entirely and may be read multiple times in the event of a retry. If the file does not exist or the current user does not have access to read it then an exception will be thrown. ";
    static final String SIMPLE_FILE_OUTPUT_DOCS = "{@link Path} to file that response contents will be written to. The file must not exist or this method will throw an exception. If the file is not writable by the current user then an exception will be thrown. ";
    protected final IntermediateModel model;
    protected final OperationModel opModel;
    protected final DocConfiguration config;
    protected final PaginationDocs paginationDocs;

    OperationDocProvider(IntermediateModel model, OperationModel opModel, DocConfiguration config) {
        this.model = model;
        this.opModel = opModel;
        this.config = config;
        this.paginationDocs = new PaginationDocs(model, opModel, this.getPaginatorDefinition());
    }

    String getDocs() {
        DocumentationBuilder docBuilder = new DocumentationBuilder();
        String description = this.getDescription();
        if (this.config.isConsumerBuilder()) {
            description = description + "<br/>" + this.getConsumerBuilderDocs();
        }
        docBuilder.description(description);
        this.applyParams(docBuilder);
        this.applyReturns(docBuilder);
        this.applyThrows(docBuilder);
        docBuilder.tag("sample", this.getInterfaceName() + "." + this.opModel.getOperationName());
        String crosslink = DocumentationUtils.createLinkToServiceDocumentation(this.model.getMetadata(), this.opModel.getOperationName());
        if (!crosslink.isEmpty()) {
            docBuilder.see(crosslink);
        }
        return docBuilder.build().replace("$", "&#36");
    }

    protected String getDescription() {
        return StringUtils.isNotBlank((CharSequence)this.opModel.getDocumentation()) ? this.opModel.getDocumentation() : this.getDefaultServiceDocs();
    }

    final String getStreamingInputDocs() {
        return String.format("The service documentation for the request content is as follows '%s'", this.getStreamingMemberDocs(this.opModel.getInputShape()));
    }

    final String getStreamingOutputDocs() {
        return String.format("The service documentation for the response content is as follows '%s'.", this.getStreamingMemberDocs(this.opModel.getOutputShape()));
    }

    private String getConsumerBuilderDocs() {
        return "<p>This is a convenience which creates an instance of the {@link " + this.opModel.getInput().getSimpleType() + ".Builder} avoiding the need to create one manually via {@link " + this.opModel.getInput().getSimpleType() + "#builder()}</p>";
    }

    private String getStreamingMemberDocs(ShapeModel streamingShape) {
        return streamingShape.getMembers().stream().filter(m -> m.getHttp().getIsStreaming()).map(DocumentationModel::getDocumentation).findFirst().orElseThrow(() -> new IllegalStateException("Streaming member not found in " + streamingShape.getShapeName()));
    }

    final List<Pair<String, String>> getThrows() {
        List<Pair<String, String>> throwsDocs = this.opModel.getExceptions().stream().map(exception -> Pair.of((Object)exception.getExceptionName(), (Object)DocumentationUtils.stripHtmlTags(exception.getDocumentation()))).collect(Collectors.toList());
        String baseServiceException = this.model.getMetadata().getBaseExceptionName();
        Collections.addAll(throwsDocs, Pair.of((Object)"SdkException ", (Object)"Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios."), Pair.of((Object)"SdkClientException ", (Object)"If any client side error occurs such as an IO related failure, failure to get credentials, etc."), Pair.of((Object)baseServiceException, (Object)"Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type."));
        return throwsDocs;
    }

    final void emitRequestParm(DocumentationBuilder docBuilder) {
        String parameterDocs = DocumentationUtils.stripHtmlTags(this.opModel.getInput().getDocumentation());
        String shapeName = this.opModel.getInputShape().getShapeName();
        ClassName fcqn = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)shapeName, (String[])new String[0]);
        if (this.config.isConsumerBuilder()) {
            docBuilder.param(this.opModel.getInput().getVariableName(), "A {@link Consumer} that will call methods on {@link %s.Builder} to create a request. %s", fcqn.toString(), parameterDocs);
        } else {
            docBuilder.param(this.opModel.getInput().getVariableName(), parameterDocs);
        }
    }

    private PaginatorDefinition getPaginatorDefinition() {
        return this.model.getPaginators().get(this.opModel.getOperationName());
    }

    protected abstract String getInterfaceName();

    protected abstract String getDefaultServiceDocs();

    protected abstract void applyParams(DocumentationBuilder var1);

    protected abstract void applyReturns(DocumentationBuilder var1);

    protected abstract void applyThrows(DocumentationBuilder var1);
}

