/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class VariableReferenceExpression
implements RuleExpression {
    private final RuleType type;
    private final String variableName;

    public VariableReferenceExpression(String variableName) {
        this.type = RuleRuntimeTypeMirror.VOID;
        this.variableName = (String)Validate.paramNotNull((Object)variableName, (String)"variableName");
    }

    VariableReferenceExpression(Builder builder) {
        this.type = builder.type;
        this.variableName = (String)Validate.paramNotNull((Object)builder.variableName, (String)"variableName");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.VARIABLE_REFERENCE;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        return buf.append(this.variableName);
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitVariableReferenceExpression(this);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public String variableName() {
        return this.variableName;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableReferenceExpression that = (VariableReferenceExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.variableName.equals(that.variableName);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.variableName.hashCode();
        return result;
    }

    public static class Builder {
        private RuleType type;
        private String variableName;

        private Builder() {
        }

        private Builder(VariableReferenceExpression expr) {
            this.variableName = expr.variableName;
            this.type = expr.type;
        }

        public Builder type(RuleType type) {
            this.type = type;
            return this;
        }

        public Builder variableName(String name) {
            this.variableName = name;
            return this;
        }

        public VariableReferenceExpression build() {
            return new VariableReferenceExpression(this);
        }
    }
}

