/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.config.customization.ConvenienceTypeOverload;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.AbstractMemberSetters;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.utils.StringUtils;

class NonCollectionSetters
extends AbstractMemberSetters {
    NonCollectionSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        super(intermediateModel, shapeModel, memberModel, typeProvider);
    }

    @Override
    public List<MethodSpec> fluentDeclarations(TypeName returnType) {
        ArrayList<MethodSpec> fluentDeclarations = new ArrayList<MethodSpec>();
        fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.memberAsParameter(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getFluentSetterDocumentation()}).build());
        if (this.memberModel().getEnumType() != null) {
            fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.modeledParam(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getFluentSetterDocumentation()}).build());
        }
        if (this.memberModel().getDeprecatedName() != null) {
            MethodSpec.Builder builder = this.fluentAbstractSetterDeclaration(this.memberModel().getDeprecatedFluentSetterMethodName(), this.memberAsParameter(), returnType);
            fluentDeclarations.add(builder.addJavadoc("$L", new Object[]{this.memberModel().getDeprecatedSetterDocumentation()}).addAnnotation(Deprecated.class).build());
        }
        if (this.memberModel().hasBuilder()) {
            fluentDeclarations.add(this.fluentConsumerFluentSetter(returnType));
        }
        return fluentDeclarations;
    }

    @Override
    public List<MethodSpec> fluent(TypeName returnType) {
        ArrayList<MethodSpec> fluentSetters = new ArrayList<MethodSpec>();
        fluentSetters.add(this.fluentAssignmentSetter(returnType));
        if (this.memberModel().getEnumType() != null) {
            fluentSetters.add(this.fluentEnumToStringSetter(returnType));
        }
        if (this.memberModel().getDeprecatedName() != null) {
            fluentSetters.add(this.fluentAssignmentSetter(this.memberModel().getDeprecatedFluentSetterMethodName(), returnType));
        }
        return fluentSetters;
    }

    public MethodSpec convenienceDeclaration(TypeName returnType, ConvenienceTypeOverload overload) {
        return MethodSpec.methodBuilder((String)this.memberModel().getFluentSetterMethodName()).addParameter((TypeName)PoetUtils.classNameFromFqcn(overload.getConvenienceType()), this.memberAsParameter().name, new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(returnType).build();
    }

    public MethodSpec fluentConvenience(TypeName returnType, ConvenienceTypeOverload overload) {
        return MethodSpec.methodBuilder((String)this.memberModel().getFluentSetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)PoetUtils.classNameFromFqcn(overload.getConvenienceType()), this.memberAsParameter().name, new Modifier[0]).addStatement("$L($T.instance().adapt($L))", new Object[]{this.memberModel().getFluentSetterMethodName(), PoetUtils.classNameFromFqcn(overload.getTypeAdapterFqcn()), this.memberAsParameter().name}).addStatement("return this", new Object[0]).returns(returnType).build();
    }

    @Override
    public List<MethodSpec> beanStyle() {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.beanStyleSetterBuilder().addCode(this.beanCopySetterBody()).build());
        if (StringUtils.isNotBlank((CharSequence)this.memberModel().getDeprecatedBeanStyleSetterMethodName())) {
            methods.add(this.deprecatedBeanStyleSetterBuilder().addCode(this.beanCopySetterBody()).addAnnotation(Deprecated.class).addJavadoc("@deprecated Use {@link #" + this.memberModel().getBeanStyleSetterMethodName() + "} instead", new Object[0]).build());
        }
        return methods;
    }

    private MethodSpec fluentAssignmentSetter(TypeName returnType) {
        return this.fluentSetterBuilder(returnType).addCode(this.copySetterBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec fluentAssignmentSetter(String methodName, TypeName returnType) {
        return this.fluentSetterBuilder(methodName, returnType).addCode(this.copySetterBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec fluentEnumToStringSetter(TypeName returnType) {
        return this.fluentSetterBuilder(this.modeledParam(), returnType).addCode(this.enumToStringAssignmentBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec fluentConsumerFluentSetter(TypeName returnType) {
        MemberModel memberModel = this.memberModel();
        ClassName memberClass = this.poetExtensions.getModelClass(memberModel.getShape().getC2jName());
        ClassName builderClass = memberClass.nestedClass("Builder");
        return this.fluentDefaultSetterDeclaration(this.builderConsumerParam(builderClass), returnType).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("return $N($T.builder().applyMutation($N).build())", new Object[]{memberModel.getFluentSetterMethodName(), memberClass, this.fieldName()}).addJavadoc("$L", new Object[]{memberModel.getDefaultConsumerFluentSetterDocumentation(memberModel.getVariable().getSimpleType())}).build();
    }

    private CodeBlock enumToStringAssignmentBody() {
        return CodeBlock.builder().addStatement("this.$N($N == null ? null : $N.toString())", new Object[]{this.memberModel().getFluentSetterMethodName(), this.fieldName(), this.fieldName()}).build();
    }

    private ParameterSpec modeledParam() {
        return ParameterSpec.builder((TypeName)this.poetExtensions.getModelClass(this.memberModel().getShape().getShapeName()), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }

    private ParameterSpec builderConsumerParam(ClassName builderClass) {
        return ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{builderClass}), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }
}

