/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.utils.Validate;

public class DelegatingAsyncClientClass
extends AsyncClientInterface {
    private final IntermediateModel model;
    private final ClassName className;
    private final PoetExtension poetExtensions;

    public DelegatingAsyncClientClass(IntermediateModel model) {
        super(model);
        this.model = model;
        this.className = ClassName.get((String)model.getMetadata().getFullClientPackageName(), (String)("Delegating" + model.getMetadata().getAsyncInterface()), (String[])new String[0]);
        this.poetExtensions = new PoetExtension(model);
    }

    @Override
    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createClassBuilder(this.className);
    }

    @Override
    protected void addInterfaceClass(TypeSpec.Builder type) {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
        type.addSuperinterface((TypeName)interfaceClass).addMethod(this.constructor(interfaceClass));
    }

    @Override
    protected void addAnnotations(TypeSpec.Builder type) {
        type.addAnnotation(SdkPublicApi.class);
    }

    @Override
    protected void addModifiers(TypeSpec.Builder type) {
        type.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
    }

    @Override
    protected void addFields(TypeSpec.Builder type) {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
        type.addField(FieldSpec.builder((TypeName)interfaceClass, (String)"delegate", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    @Override
    protected void addAdditionalMethods(TypeSpec.Builder type) {
        type.addMethod(this.nameMethod()).addMethod(this.delegateMethod()).addMethod(this.invokeMethod());
    }

    private MethodSpec nameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return delegate.serviceName()", new Object[0]).build();
    }

    private MethodSpec delegateMethod() {
        return MethodSpec.methodBuilder((String)"delegate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this.delegate", new Object[0]).returns(SdkClient.class).build();
    }

    private MethodSpec invokeMethod() {
        TypeVariableName requestTypeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{this.poetExtensions.getModelClass(this.model.getSdkRequestBaseClassName())});
        TypeVariableName responseTypeVariableName = STREAMING_TYPE_VARIABLE;
        ParameterizedTypeName responseFutureTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{responseTypeVariableName});
        ParameterizedTypeName functionTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{requestTypeVariableName, responseFutureTypeName});
        return MethodSpec.methodBuilder((String)"invokeOperation").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)requestTypeVariableName, "request", new Modifier[0]).addParameter((TypeName)functionTypeName, "operation", new Modifier[0]).addTypeVariable(requestTypeVariableName).addTypeVariable(responseTypeVariableName).returns((TypeName)responseFutureTypeName).addStatement("return operation.apply(request)", new Object[0]).build();
    }

    @Override
    protected MethodSpec serviceClientConfigMethod() {
        return MethodSpec.methodBuilder((String)"serviceClientConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)new PoetExtension(this.model).getServiceConfigClass()).addStatement("return delegate.serviceClientConfiguration()", new Object[0]).build();
    }

    @Override
    protected void addCloseMethod(TypeSpec.Builder type) {
        MethodSpec method = MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("delegate.close()", new Object[0]).build();
        type.addMethod(method);
    }

    protected List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().flatMap(this::operations).sorted(Comparator.comparing(m -> m.name)).collect(Collectors.toList());
    }

    private Stream<MethodSpec> operations(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.traditionalMethod(opModel));
        return methods.stream();
    }

    private MethodSpec constructor(ClassName interfaceClass) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)interfaceClass, "delegate", new Modifier[0]).addStatement("$T.paramNotNull(delegate, \"delegate\")", new Object[]{Validate.class}).addStatement("this.delegate = delegate", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
        if (builder.parameters.isEmpty()) {
            throw new IllegalStateException("All client methods must have an argument");
        }
        ArrayList parameters = new ArrayList(builder.parameters);
        String requestParameter = ((ParameterSpec)parameters.remove((int)0)).name;
        String additionalParameters = String.format(", %s", parameters.stream().map(p -> p.name).collect(Collectors.joining(", ")));
        builder.addStatement("return invokeOperation($N, request -> delegate.$N(request$N))", new Object[]{requestParameter, opModel.getMethodName(), parameters.isEmpty() ? "" : additionalParameters});
        return builder;
    }

    @Override
    protected MethodSpec.Builder utilitiesOperationBody(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return delegate.$N()", new Object[]{"utilities"});
    }

    @Override
    protected MethodSpec.Builder waiterOperationBody(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return delegate.waiter()", new Object[0]);
    }
}

