/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadata;
import software.amazon.awssdk.codegen.poet.auth.scheme.ModelAuthSchemeKnowledgeIndex;

public final class AuthSchemeCodegenKnowledgeIndex {
    private final Map<List<String>, List<AuthSchemeCodegenMetadata>> operationsToAuthSchemes;

    private AuthSchemeCodegenKnowledgeIndex(IntermediateModel intermediateModel) {
        this.operationsToAuthSchemes = ModelAuthSchemeKnowledgeIndex.of(intermediateModel).operationsToMetadata();
    }

    public static AuthSchemeCodegenKnowledgeIndex of(IntermediateModel intermediateModel) {
        return new AuthSchemeCodegenKnowledgeIndex(intermediateModel);
    }

    public List<AuthSchemeCodegenMetadata> serviceDefaultAuthSchemes() {
        return this.operationsToAuthSchemes.get(Collections.emptyList());
    }

    public boolean hasPerOperationAuthSchemesOverrides() {
        return this.operationsToAuthSchemes.size() > 1;
    }

    public void forEachOperationsOverridesGroup(BiConsumer<List<String>, List<AuthSchemeCodegenMetadata>> consumer) {
        for (Map.Entry<List<String>, List<AuthSchemeCodegenMetadata>> kvp : this.operationsToAuthSchemes.entrySet()) {
            if (kvp.getKey().isEmpty()) continue;
            consumer.accept(kvp.getKey(), kvp.getValue());
        }
    }
}

