/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;

public class GeneratorPathProvider {
    private final IntermediateModel model;
    private final String sourceDirectory;
    private final String resourcesDirectory;
    private final String testDirectory;

    public GeneratorPathProvider(IntermediateModel model, String sourceDirectory, String testDirectory, String resourcesDirectory) {
        this.model = model;
        this.sourceDirectory = sourceDirectory;
        this.resourcesDirectory = resourcesDirectory;
        this.testDirectory = testDirectory;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public String getTestDirectory() {
        return this.testDirectory;
    }

    public String getModelDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullModelPackageName());
    }

    public String getTransformDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullTransformPackageName());
    }

    public String getClientDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullClientPackageName());
    }

    public String getClientInternalDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullClientInternalPackageName());
    }

    public String getPaginatorsDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullPaginatorsPackageName());
    }

    public String getAuthorizerDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullAuthPolicyPackageName());
    }

    public String getWaitersDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullWaitersPackageName());
    }

    public String getWaitersInternalDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullWaitersInternalPackageName());
    }

    public String getEndpointRulesDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullEndpointRulesPackageName());
    }

    public String getEndpointRulesInternalDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullInternalEndpointRulesPackageName());
    }

    public String getEndpointRulesInternalResourcesDirectory() {
        return this.resourcesDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullInternalEndpointRulesPackageName());
    }

    public String getEndpointRulesTestDirectory() {
        return this.testDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullEndpointRulesPackageName());
    }

    public String getAuthSchemeDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullAuthSchemePackageName());
    }

    public String getAuthSchemeInternalDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullInternalAuthSchemePackageName());
    }

    public String getJmesPathInternalDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullInternalJmesPathPackageName());
    }
}

