/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointParametersClassSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointParametersClassSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addJavadoc("The parameters object used to resolve an endpoint for the $L service.", new Object[]{this.intermediateModel.getMetadata().getServiceName()}).addMethod(this.ctor()).addMethod(this.builderMethod()).addType(this.builderInterfaceSpec()).addType(this.builderImplSpec()).addAnnotation(SdkPublicApi.class).addSuperinterface(this.toCopyableBuilderInterface()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.parameters().forEach((name, model) -> {
            b.addField(this.endpointRulesSpecUtils.parameterClassField((String)name, (ParameterModel)model));
            b.addMethod(this.endpointRulesSpecUtils.parameterClassAccessorMethod((String)name, (ParameterModel)model));
        });
        b.addMethod(this.toBuilderMethod());
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.parametersClassName();
    }

    private TypeSpec builderInterfaceSpec() {
        TypeSpec.Builder b = TypeSpec.interfaceBuilder((ClassName)this.builderInterfaceName()).addSuperinterface(this.copyableBuilderExtendsInterface()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.parameters().forEach((name, model) -> b.addMethod(this.endpointRulesSpecUtils.parameterBuilderSetterMethodDeclaration(this.className(), (String)name, (ParameterModel)model)));
        b.addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.className()).build());
        return b.build();
    }

    private TypeSpec builderImplSpec() {
        TypeSpec.Builder b = TypeSpec.classBuilder((ClassName)this.builderClassName()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addSuperinterface((TypeName)this.builderInterfaceName());
        b.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        b.addMethod(this.toBuilderConstructor().build());
        this.parameters().forEach((name, model) -> {
            b.addField(this.endpointRulesSpecUtils.parameterBuilderFieldSpec((String)name, (ParameterModel)model));
            b.addMethod(this.endpointRulesSpecUtils.parameterBuilderSetterMethod(this.className(), (String)name, (ParameterModel)model));
        });
        b.addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.className()).addCode(CodeBlock.builder().addStatement("return new $T(this)", new Object[]{this.className()}).build()).build());
        return b.build();
    }

    private ClassName builderInterfaceName() {
        return this.className().nestedClass("Builder");
    }

    private ClassName builderClassName() {
        return this.className().nestedClass("BuilderImpl");
    }

    private Map<String, ParameterModel> parameters() {
        return this.intermediateModel.getEndpointRuleSetModel().getParameters();
    }

    private MethodSpec ctor() {
        MethodSpec.Builder b = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.builderClassName(), "builder", new Modifier[0]);
        this.parameters().forEach((name, model) -> b.addStatement("this.$1N = builder.$1N", new Object[]{this.variableName((String)name)}));
        return b.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.builderInterfaceName()).addStatement("return new $T()", new Object[]{this.builderClassName()}).build();
    }

    private MethodSpec toBuilderMethod() {
        return MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderInterfaceName()).addStatement("return new $T(this)", new Object[]{this.builderClassName()}).build();
    }

    private String variableName(String name) {
        return this.intermediateModel.getNamingStrategy().getVariableName(name);
    }

    private MethodSpec.Builder toBuilderConstructor() {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addModifiers(new Modifier[]{Modifier.PRIVATE});
        constructorBuilder.addParameter((TypeName)this.className(), "builder", new Modifier[0]);
        this.parameters().forEach((name, model) -> constructorBuilder.addStatement("this.$1N = builder.$1N", new Object[]{this.variableName((String)name)}));
        return constructorBuilder;
    }

    private TypeName toCopyableBuilderInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ToCopyableBuilder.class), (TypeName[])new TypeName[]{this.className().nestedClass(this.builderInterfaceName().simpleName()), this.className()});
    }

    private TypeName copyableBuilderExtendsInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(CopyableBuilder.class), (TypeName[])new TypeName[]{this.builderInterfaceName(), this.className()});
    }
}

