/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.ListExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class HeadersExpression
implements RuleExpression {
    private static final HeadersExpression EMPTY = new HeadersExpression(Collections.emptyMap());
    private final RuleType type = RuleRuntimeTypeMirror.VOID;
    private final Map<String, ListExpression> headers;

    HeadersExpression(Builder builder) {
        this.headers = Collections.unmodifiableMap(new LinkedHashMap(builder.headers));
    }

    HeadersExpression(Map<String, ListExpression> headers) {
        this.headers = headers;
    }

    public static HeadersExpression empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.HEADERS;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("{:type :headers");
        this.headers.forEach((k, v) -> {
            buf.append(", :").append((String)k).append(" ");
            v.appendTo(buf);
        });
        buf.append("}");
        return buf;
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitHeadersExpression(this);
    }

    public Map<String, ListExpression> headers() {
        return this.headers;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersExpression that = (HeadersExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.headers.equals(that.headers);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.headers.hashCode();
        return result;
    }

    public static class Builder {
        private final Map<String, ListExpression> headers = new LinkedHashMap<String, ListExpression>();

        public Builder putHeader(String name, ListExpression value) {
            this.headers.put((String)Validate.paramNotNull((Object)name, (String)"name"), (ListExpression)Validate.paramNotNull((Object)value, (String)"value"));
            return this;
        }

        public HeadersExpression build() {
            if (this.headers.isEmpty()) {
                return EMPTY;
            }
            return new HeadersExpression(this);
        }
    }
}

