/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.auth.token.credentials.aws.DefaultAwsTokenProvider;
import software.amazon.awssdk.auth.token.signer.aws.BearerTokenSigner;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.utils.AuthUtils;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class BaseClientBuilderInterface
implements ClassSpec {
    private static final ParameterizedTypeName TOKEN_IDENTITY_PROVIDER_TYPE_NAME = ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(TokenIdentity.class)});
    private final IntermediateModel model;
    private final String basePackage;
    private final ClassName builderInterfaceName;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final AuthSchemeSpecUtils authSchemeSpecUtils;

    public BaseClientBuilderInterface(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createInterfaceBuilder(this.builderInterfaceName).addAnnotation(SdkPublicApi.class).addTypeVariable(PoetUtils.createBoundedTypeVariableName("B", this.builderInterfaceName, "B", "C")).addTypeVariable(TypeVariableName.get((String)"C")).addSuperinterface((TypeName)PoetUtils.createParameterizedTypeName(AwsClientBuilder.class, "B", "C")).addJavadoc(this.getJavadoc());
        if (this.model.getEndpointOperation().isPresent()) {
            if (this.model.getCustomizationConfig().isEnableEndpointDiscoveryMethodRequired()) {
                builder.addMethod(this.enableEndpointDiscovery());
            }
            builder.addMethod(this.endpointDiscovery());
        }
        if (this.model.getCustomizationConfig().getServiceConfig().getClassName() != null) {
            builder.addMethod(this.serviceConfigurationMethod());
            builder.addMethod(this.serviceConfigurationConsumerBuilderMethod());
        }
        builder.addMethod(this.endpointProviderMethod());
        builder.addMethod(this.authSchemeProviderMethod());
        if (this.hasClientContextParams()) {
            this.model.getClientContextParams().forEach((n, m) -> builder.addMethod(this.clientContextParamSetter((String)n, (ClientContextParam)m)));
        }
        if (this.hasSdkClientContextParams()) {
            this.model.getCustomizationConfig().getCustomClientContextParams().forEach((n, m) -> builder.addMethod(this.clientContextParamSetter((String)n, (ClientContextParam)m)));
        }
        if (this.generateTokenProviderMethod()) {
            builder.addMethod(this.tokenProviderMethod());
            builder.addMethod(this.tokenIdentityProviderMethod());
        }
        return builder.build();
    }

    private CodeBlock getJavadoc() {
        return CodeBlock.of((String)"This includes configuration specific to $L that is supported by both {@link $T} and {@link $T}.", (Object[])new Object[]{this.model.getMetadata().getDescriptiveServiceName(), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getAsyncBuilderInterface(), (String[])new String[0])});
    }

    private MethodSpec enableEndpointDiscovery() {
        return MethodSpec.methodBuilder((String)"enableEndpointDiscovery").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeVariableName.get((String)"B")).addAnnotation(Deprecated.class).addJavadoc("@deprecated Use {@link #endpointDiscoveryEnabled($T)} instead.", new Object[]{Boolean.TYPE}).build();
    }

    private MethodSpec endpointDiscovery() {
        return MethodSpec.methodBuilder((String)"endpointDiscoveryEnabled").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter(Boolean.TYPE, "endpointDiscovery", new Modifier[0]).build();
    }

    private MethodSpec serviceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).build();
    }

    private MethodSpec serviceConfigurationConsumerBuilderMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        ParameterizedTypeName consumerBuilder = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{serviceConfiguration.nestedClass("Builder")});
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)consumerBuilder, "serviceConfiguration", new Modifier[0]).addStatement("return serviceConfiguration($T.builder().applyMutation(serviceConfiguration).build())", new Object[]{serviceConfiguration}).build();
    }

    private MethodSpec endpointProviderMethod() {
        return MethodSpec.methodBuilder((String)"endpointProvider").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)this.endpointRulesSpecUtils.providerInterfaceName(), "endpointProvider", new Modifier[0]).addJavadoc("Set the {@link $T} implementation that will be used by the client to determine the endpoint for each request. This is optional; if none is provided a default implementation will be used the SDK.", new Object[]{this.endpointRulesSpecUtils.providerInterfaceName()}).returns((TypeName)TypeVariableName.get((String)"B")).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).build();
    }

    private MethodSpec authSchemeProviderMethod() {
        return MethodSpec.methodBuilder((String)"authSchemeProvider").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)this.authSchemeSpecUtils.providerInterfaceName(), "authSchemeProvider", new Modifier[0]).addJavadoc("Set the {@link $T} implementation that will be used by the client to resolve the auth scheme for each request. This is optional; if none is provided a default implementation will be used the SDK.", new Object[]{this.authSchemeSpecUtils.providerInterfaceName()}).returns((TypeName)TypeVariableName.get((String)"B")).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).build();
    }

    private MethodSpec clientContextParamSetter(String name, ClientContextParam param) {
        String setterName = Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)name));
        TypeName type = this.endpointRulesSpecUtils.toJavaType(param.getType());
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)setterName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(type, setterName, new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"B"));
        PoetUtils.addJavadoc(x$0 -> b.addJavadoc(x$0, new Object[0]), param.getDocumentation());
        return b.build();
    }

    private boolean generateTokenProviderMethod() {
        return AuthUtils.usesBearerAuth(this.model);
    }

    private MethodSpec tokenProviderMethod() {
        return MethodSpec.methodBuilder((String)"tokenProvider").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter(SdkTokenProvider.class, "tokenProvider", new Modifier[0]).addJavadoc("Set the token provider to use for bearer token authorization. This is optional, if none is provided, the SDK will use {@link $T}.\n<p>\nIf the service, or any of its operations require Bearer Token Authorization, then the SDK will default to this token provider to retrieve the token to use for authorization.\n<p>\nThis provider works in conjunction with the {@code $T.TOKEN_SIGNER} set on the client. By default it is {@link $T}.", new Object[]{DefaultAwsTokenProvider.class, SdkAdvancedClientOption.class, BearerTokenSigner.class}).addStatement("return tokenProvider(($T) tokenProvider)", new Object[]{TOKEN_IDENTITY_PROVIDER_TYPE_NAME}).build();
    }

    private MethodSpec tokenIdentityProviderMethod() {
        return MethodSpec.methodBuilder((String)"tokenProvider").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)TOKEN_IDENTITY_PROVIDER_TYPE_NAME, "tokenProvider", new Modifier[0]).addJavadoc("Set the token provider to use for bearer token authorization. This is optional, if none is provided, the SDK will use {@link $T}.\n<p>\nIf the service, or any of its operations require Bearer Token Authorization, then the SDK will default to this token provider to retrieve the token to use for authorization.\n<p>\nThis provider works in conjunction with the {@code $T.TOKEN_SIGNER} set on the client. By default it is {@link $T}.", new Object[]{DefaultAwsTokenProvider.class, SdkAdvancedClientOption.class, BearerTokenSigner.class}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).build();
    }

    @Override
    public ClassName className() {
        return this.builderInterfaceName;
    }

    private boolean hasClientContextParams() {
        return this.model.getClientContextParams() != null && !this.model.getClientContextParams().isEmpty();
    }

    private boolean hasSdkClientContextParams() {
        return this.model.getCustomizationConfig() != null && this.model.getCustomizationConfig().getCustomClientContextParams() != null && !this.model.getCustomizationConfig().getCustomClientContextParams().isEmpty();
    }
}

