/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.utils.Validate;

public class RuleType {
    private static final ClassName LIST = ClassName.get(List.class);
    private final String name;
    private final TypeName type;
    private final TypeName baseType;
    private final List<TypeName> typeParams;
    private final Map<String, RuleType> properties;
    private final RuleType ruleTypeParam;
    private final String className;
    private final String packageName;

    RuleType(Builder builder) {
        this.name = (String)Validate.paramNotNull((Object)builder.name, (String)"name");
        this.baseType = builder.baseType;
        this.typeParams = Collections.unmodifiableList(new ArrayList(builder.typeParams));
        this.properties = Collections.unmodifiableMap(new LinkedHashMap(builder.properties));
        this.ruleTypeParam = builder.ruleTypeParam;
        this.className = builder.className;
        this.packageName = builder.packageName;
        this.type = builder.baseType == null ? RuleType.javaType((TypeName)ClassName.get((String)builder.packageName, (String)builder.className, (String[])new String[0]), this.typeParams) : RuleType.javaType(this.baseType, this.typeParams);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    static TypeName javaType(TypeName base, List<TypeName> params) {
        if (params.isEmpty()) {
            return base;
        }
        if (!(base instanceof ClassName)) {
            throw new IllegalArgumentException("Cannot cast base to ClassName");
        }
        TypeName[] paramTypes = params.toArray(new TypeName[0]);
        return ParameterizedTypeName.get((ClassName)((ClassName)base), (TypeName[])paramTypes);
    }

    public TypeName javaType() {
        return this.type;
    }

    public List<TypeName> typeParams() {
        return this.typeParams;
    }

    public Map<String, RuleType> properties() {
        return this.properties;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleType ruleType = (RuleType)o;
        if (!Objects.equals(this.name, ruleType.name)) {
            return false;
        }
        if (!Objects.equals(this.type, ruleType.type)) {
            return false;
        }
        if (!Objects.equals(this.baseType, ruleType.baseType)) {
            return false;
        }
        if (!Objects.equals(this.typeParams, ruleType.typeParams)) {
            return false;
        }
        if (!Objects.equals(this.properties, ruleType.properties)) {
            return false;
        }
        if (!Objects.equals(this.ruleTypeParam, ruleType.ruleTypeParam)) {
            return false;
        }
        if (!Objects.equals(this.className, ruleType.className)) {
            return false;
        }
        return Objects.equals(this.packageName, ruleType.packageName);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.baseType != null ? this.baseType.hashCode() : 0);
        result = 31 * result + (this.typeParams != null ? this.typeParams.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.ruleTypeParam != null ? this.ruleTypeParam.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        return result;
    }

    public RuleType property(String name) {
        return this.properties.get(name);
    }

    public RuleType ruleTypeParam() {
        return this.ruleTypeParam;
    }

    public boolean isList() {
        return this.baseType.equals((Object)LIST);
    }

    public RuleType typeParam() {
        return this.ruleTypeParam;
    }

    public String name() {
        return this.name;
    }

    public TypeName type() {
        return this.type;
    }

    public TypeName baseType() {
        return this.baseType;
    }

    public String className() {
        return this.className;
    }

    public String packageName() {
        return this.packageName;
    }

    public static class Builder {
        private final String name;
        private final List<TypeName> typeParams = new ArrayList<TypeName>();
        private final Map<String, RuleType> properties = new LinkedHashMap<String, RuleType>();
        private TypeName baseType;
        private RuleType ruleTypeParam;
        private String className;
        private String packageName;

        private Builder(String name) {
            this.name = name;
        }

        public Builder baseType(TypeName baseType) {
            this.baseType = baseType;
            return this;
        }

        public Builder addTypeParam(TypeName param) {
            this.typeParams.add(param);
            return this;
        }

        public Builder ruleTypeParam(RuleType type) {
            this.ruleTypeParam = type;
            return this;
        }

        public Builder putProperty(String name, RuleType type) {
            this.properties.put(name, type);
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public RuleType build() {
            return new RuleType(this);
        }
    }
}

