/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import software.amazon.awssdk.utils.ToString;

public class Tokenizer {
    private static final Token EOF = new Token(TokenKind.EOF, "");
    private final List<Token> tokens;
    private int index = 0;

    public Tokenizer(String source) {
        this.tokens = Tokenizer.tokenize(source);
    }

    private static List<Token> tokenize(String source) {
        Token token;
        ArrayList<Token> tokens = new ArrayList<Token>();
        TokenizerState state = new TokenizerState(source);
        do {
            token = Tokenizer.next(state);
            tokens.add(token);
        } while (token.type != TokenKind.EOF);
        return tokens;
    }

    private static Token next(TokenizerState state) {
        if (!state.hasNext()) {
            return EOF;
        }
        char ch = state.next();
        if (ch == '{') {
            if (state.peek() == '{') {
                state.next();
                return Tokenizer.consumeString(state, '{');
            }
            return new Token(TokenKind.OPEN_CURLY, "{");
        }
        if (ch == '}') {
            if (state.peek() == '}') {
                state.next();
                return Tokenizer.consumeString(state, '}');
            }
            return new Token(TokenKind.CLOSE_CURLY, "}");
        }
        if (ch == '[') {
            if (state.peek() == '[') {
                state.next();
                return Tokenizer.consumeString(state, '[');
            }
            return new Token(TokenKind.OPEN_SQUARE, "[");
        }
        if (ch == ']') {
            if (state.peek() == ']') {
                state.next();
                return Tokenizer.consumeString(state, ']');
            }
            return new Token(TokenKind.CLOSE_SQUARE, "]");
        }
        if (ch == '#') {
            return new Token(TokenKind.HASH, "#");
        }
        if (Tokenizer.isDigit(ch)) {
            return Tokenizer.consumeNumber(state, ch);
        }
        if (Tokenizer.isIdentifierStart(ch)) {
            return Tokenizer.consumeIdentifierOrString(state, ch);
        }
        return Tokenizer.consumeString(state, ch);
    }

    private static Token consumeNumber(TokenizerState state, char start) {
        char ch;
        StringBuilder buf = new StringBuilder();
        buf.append(start);
        while (Tokenizer.isDigit(ch = state.peek())) {
            buf.append(state.next());
        }
        return new Token(TokenKind.NUMBER, buf.toString());
    }

    private static Token consumeIdentifierOrString(TokenizerState state, char start) {
        char ch;
        StringBuilder buf = new StringBuilder();
        buf.append(start);
        while (Tokenizer.isIdentifierPart(ch = state.peek())) {
            buf.append(state.next());
        }
        if (Tokenizer.isSpecialChar(ch)) {
            return new Token(TokenKind.IDENTIFIER, buf.toString());
        }
        return Tokenizer.consumeString(state, buf);
    }

    private static Token consumeString(TokenizerState state, char start) {
        StringBuilder buf = new StringBuilder();
        buf.append(start);
        return Tokenizer.consumeString(state, buf);
    }

    private static Token consumeString(TokenizerState state, StringBuilder buf) {
        char ch;
        while (!Tokenizer.isSpecialChar(ch = state.peek())) {
            buf.append(state.next());
        }
        return new Token(TokenKind.STRING, buf.toString());
    }

    private static boolean isSpecialChar(char ch) {
        switch (ch) {
            case '\u0000': 
            case '#': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static boolean isIdentifierStart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
    }

    private static boolean isIdentifierPart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public Token peek() {
        if (this.index >= this.tokens.size()) {
            throw new IllegalStateException("Peek called with out of bounds index");
        }
        return this.tokens.get(this.index);
    }

    public Token next() {
        if (this.atEof()) {
            return EOF;
        }
        Token res = this.tokens.get(this.index);
        ++this.index;
        return res;
    }

    public boolean matches(TokenKind ... kinds) {
        if (this.index + kinds.length >= this.tokens.size()) {
            return false;
        }
        for (int idx = 0; idx < kinds.length; ++idx) {
            if (this.tokens.get(this.index + idx).type == kinds[idx]) continue;
            return false;
        }
        return true;
    }

    public boolean isIndexedAccess() {
        return this.matches(TokenKind.IDENTIFIER, TokenKind.OPEN_SQUARE, TokenKind.NUMBER, TokenKind.CLOSE_SQUARE);
    }

    public void consumeIndexed(BiConsumer<String, Integer> consumer) {
        if (!this.isIndexedAccess()) {
            throw new IllegalStateException("not at indexed");
        }
        consumer.accept(this.tokens.get(this.index).value, Integer.parseInt(this.tokens.get(this.index + 2).value));
        this.index += 4;
    }

    public boolean isNamedAccess() {
        return this.matches(TokenKind.OPEN_CURLY, TokenKind.IDENTIFIER, TokenKind.HASH, TokenKind.IDENTIFIER, TokenKind.CLOSE_CURLY);
    }

    public void consumeNamedAccess(BiConsumer<String, String> consumer) {
        if (!this.isNamedAccess()) {
            throw new IllegalStateException("not at named access");
        }
        consumer.accept(this.tokens.get(this.index + 1).value, this.tokens.get(this.index + 3).value);
        this.index += 5;
    }

    public boolean isReference() {
        return this.matches(TokenKind.OPEN_CURLY, TokenKind.IDENTIFIER, TokenKind.CLOSE_CURLY);
    }

    public boolean isIdentifier() {
        return this.matches(TokenKind.IDENTIFIER);
    }

    public void consumeIdentifier(Consumer<String> consumer) {
        if (!this.isIdentifier()) {
            throw new IllegalStateException("not at identifier");
        }
        consumer.accept(this.tokens.get(this.index).value);
        ++this.index;
    }

    public void expectAtEof(String state) {
        if (!this.atEof()) {
            throw new IllegalArgumentException(String.format("unexpected extra tokens while parsing %s, starting at: %s", state, this.peek()));
        }
    }

    public void consumeReferenceAccess(Consumer<String> consumer) {
        if (!this.isReference()) {
            throw new IllegalStateException("not at reference expression");
        }
        consumer.accept(this.tokens.get(this.index + 1).value);
        this.index += 3;
    }

    public boolean atEof() {
        return this.index >= this.tokens.size() - 1;
    }

    static class Token {
        private final TokenKind type;
        private final String value;

        Token(TokenKind type, String value) {
            this.type = type;
            this.value = value;
        }

        public TokenKind type() {
            return this.type;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return ToString.builder((String)"Token").add("type", (Object)this.type).add("value", (Object)this.value).build();
        }
    }

    static class TokenizerState {
        private final String source;
        private int index = 0;

        TokenizerState(String source) {
            this.source = source;
        }

        public char peek() {
            if (this.index == this.source.length()) {
                return '\u0000';
            }
            return this.source.charAt(this.index);
        }

        public boolean hasNext() {
            return this.index < this.source.length();
        }

        public char next() {
            if (this.index == this.source.length()) {
                return '\u0000';
            }
            char res = this.source.charAt(this.index);
            ++this.index;
            return res;
        }
    }

    static enum TokenKind {
        STRING,
        NUMBER,
        IDENTIFIER,
        HASH,
        OPEN_CURLY,
        CLOSE_CURLY,
        OPEN_SQUARE,
        CLOSE_SQUARE,
        EOF;

    }
}

