/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class EndpointRulesSpecUtils {
    private final IntermediateModel intermediateModel;

    public EndpointRulesSpecUtils(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
    }

    public String basePackage() {
        return this.intermediateModel.getMetadata().getFullEndpointRulesPackageName();
    }

    public ClassName rulesRuntimeClassName(String name) {
        return ClassName.get((String)this.intermediateModel.getMetadata().getFullInternalEndpointRulesPackageName(), (String)name, (String[])new String[0]);
    }

    public ClassName parametersClassName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "EndpointParams"), (String[])new String[0]);
    }

    public ClassName providerInterfaceName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "EndpointProvider"), (String[])new String[0]);
    }

    public ClassName providerDefaultImplName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)("Default" + this.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName resolverInterceptorName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)(md.getServiceName() + "ResolveEndpointInterceptor"), (String[])new String[0]);
    }

    public ClassName requestModifierInterceptorName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)(md.getServiceName() + "RequestSetEndpointInterceptor"), (String[])new String[0]);
    }

    public ClassName clientEndpointTestsName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullEndpointRulesPackageName(), (String)(md.getServiceName() + "ClientEndpointTests"), (String[])new String[0]);
    }

    public ClassName endpointProviderTestsName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullEndpointRulesPackageName(), (String)(md.getServiceName() + "EndpointProviderTests"), (String[])new String[0]);
    }

    public ClassName clientContextParamsName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullEndpointRulesPackageName(), (String)(md.getServiceName() + "ClientContextParams"), (String[])new String[0]);
    }

    public String paramMethodName(String param) {
        return Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)param));
    }

    public String clientContextParamMethodName(String param) {
        return Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)param));
    }

    public String clientContextParamName(String paramName) {
        return this.intermediateModel.getNamingStrategy().getEnumValueName(paramName);
    }

    public TypeName toJavaType(String type) {
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "boolean": {
                return TypeName.get(Boolean.class);
            }
            case "string": {
                return TypeName.get(String.class);
            }
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public CodeBlock valueCreationCode(String type, CodeBlock param) {
        String methodName;
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "boolean": {
                methodName = "fromBool";
                break;
            }
            case "string": {
                methodName = "fromStr";
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to create a Value instance from type " + type);
            }
        }
        return CodeBlock.builder().add("$T.$N($L)", new Object[]{this.rulesRuntimeClassName("Value"), methodName, param}).build();
    }

    public TypeName parameterType(ParameterModel param) {
        if (param.getBuiltInEnum() == null || param.getBuiltInEnum() != BuiltInParameter.AWS_REGION) {
            return this.toJavaType(param.getType());
        }
        if (param.getBuiltInEnum() == BuiltInParameter.AWS_REGION) {
            return ClassName.get(Region.class);
        }
        return this.toJavaType(param.getType());
    }

    public CodeBlock treeNodeToLiteral(TreeNode treeNode) {
        CodeBlock.Builder b = CodeBlock.builder();
        switch (treeNode.asToken()) {
            case VALUE_STRING: {
                b.add("$S", new Object[]{((JrsString)Validate.isInstanceOf(JrsString.class, (Object)treeNode, (String)"Expected string", (Object[])new Object[0])).getValue()});
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                b.add("$L", new Object[]{((JrsBoolean)Validate.isInstanceOf(JrsBoolean.class, (Object)treeNode, (String)"Expected boolean", (Object[])new Object[0])).booleanValue()});
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to set default value for parameter of type " + treeNode.asToken());
            }
        }
        return b.build();
    }

    public boolean isS3() {
        return "S3".equals(this.intermediateModel.getMetadata().getServiceName());
    }

    public boolean isS3Control() {
        return "S3Control".equals(this.intermediateModel.getMetadata().getServiceName());
    }

    public boolean useS3Express() {
        return this.intermediateModel.getCustomizationConfig().getS3ExpressAuthSupport();
    }

    public TypeName resolverReturnType() {
        return ParameterizedTypeName.get(CompletableFuture.class, (Type[])new Type[]{Endpoint.class});
    }

    public List<String> rulesEngineResourceFiles() {
        List<String> list;
        URL currentJarUrl = EndpointRulesSpecUtils.class.getProtectionDomain().getCodeSource().getLocation();
        JarFile jarFile = new JarFile(currentJarUrl.getFile());
        try {
            list = jarFile.stream().map(ZipEntry::getName).filter(e -> e.startsWith("software/amazon/awssdk/codegen/rules/")).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        jarFile.close();
        return list;
    }

    public List<String> rulesEngineResourceFiles2() {
        List<String> list;
        URL currentJarUrl = EndpointRulesSpecUtils.class.getProtectionDomain().getCodeSource().getLocation();
        JarFile jarFile = new JarFile(currentJarUrl.getFile());
        try {
            list = jarFile.stream().map(ZipEntry::getName).filter(e -> e.startsWith("software/amazon/awssdk/codegen/rules2/")).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        jarFile.close();
        return list;
    }

    public Map<String, ParameterModel> parameters() {
        return this.intermediateModel.getEndpointRuleSetModel().getParameters();
    }

    public boolean isDeclaredParam(String paramName) {
        Map<String, ParameterModel> parameters = this.intermediateModel.getEndpointRuleSetModel().getParameters();
        return parameters.containsKey(paramName);
    }

    public FieldSpec parameterClassField(String name, ParameterModel model) {
        return this.parameterFieldSpecBuilder(name, model).addModifiers(new Modifier[]{Modifier.PRIVATE}).addModifiers(new Modifier[]{Modifier.FINAL}).build();
    }

    public MethodSpec parameterClassAccessorMethod(String name, ParameterModel model) {
        MethodSpec.Builder b = this.parameterMethodBuilder(name, model);
        b.returns(this.parameterType(model));
        b.addStatement("return $N", new Object[]{this.variableName(name)});
        return b.build();
    }

    public MethodSpec parameterInterfaceAccessorMethod(String name, ParameterModel model) {
        MethodSpec.Builder b = this.parameterMethodBuilder(name, model);
        b.returns(this.parameterType(model));
        b.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        return b.build();
    }

    public FieldSpec parameterBuilderFieldSpec(String name, ParameterModel model) {
        return this.parameterFieldSpecBuilder(name, model).initializer(this.parameterDefaultValueCode(model)).build();
    }

    public MethodSpec parameterBuilderSetterMethodDeclaration(ClassName containingClass, String name, ParameterModel model) {
        MethodSpec.Builder b = this.parameterMethodBuilder(name, model);
        b.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        b.addParameter(this.parameterSpec(name, model));
        b.returns((TypeName)containingClass.nestedClass("Builder"));
        return b.build();
    }

    public MethodSpec parameterBuilderSetterMethod(ClassName containingClass, String name, ParameterModel model) {
        String memberName = this.variableName(name);
        MethodSpec.Builder b = this.parameterMethodBuilder(name, model).addAnnotation(Override.class).addParameter(this.parameterSpec(name, model)).returns((TypeName)containingClass.nestedClass("Builder")).addStatement("this.$1N = $1N", new Object[]{memberName});
        TreeNode defaultValue = model.getDefault();
        if (defaultValue != null) {
            b.beginControlFlow("if (this.$N == null)", new Object[]{memberName});
            b.addStatement("this.$N = $L", new Object[]{memberName, this.parameterDefaultValueCode(model)});
            b.endControlFlow();
        }
        b.addStatement("return this", new Object[0]);
        return b.build();
    }

    private FieldSpec.Builder parameterFieldSpecBuilder(String name, ParameterModel model) {
        return FieldSpec.builder((TypeName)this.parameterType(model), (String)this.variableName(name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
    }

    private ParameterSpec parameterSpec(String name, ParameterModel model) {
        return ParameterSpec.builder((TypeName)this.parameterType(model), (String)this.variableName(name), (Modifier[])new Modifier[0]).build();
    }

    private MethodSpec.Builder parameterMethodBuilder(String name, ParameterModel model) {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)this.paramMethodName(name));
        b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (model.getDeprecated() != null) {
            b.addAnnotation(Deprecated.class);
        }
        return b;
    }

    private CodeBlock parameterDefaultValueCode(ParameterModel parameterModel) {
        CodeBlock.Builder b = CodeBlock.builder();
        TreeNode defaultValue = parameterModel.getDefault();
        if (defaultValue == null) {
            return b.build();
        }
        switch (defaultValue.asToken()) {
            case VALUE_STRING: {
                String stringValue = ((JrsString)defaultValue).getValue();
                if (parameterModel.getBuiltInEnum() == BuiltInParameter.AWS_REGION) {
                    b.add("$T.of($S)", new Object[]{Region.class, stringValue});
                    break;
                }
                b.add("$S", new Object[]{stringValue});
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                b.add("$L", new Object[]{((JrsBoolean)defaultValue).booleanValue()});
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to set default value for parameter of type " + defaultValue.asToken());
            }
        }
        return b.build();
    }

    public String variableName(String name) {
        return this.intermediateModel.getNamingStrategy().getVariableName(name);
    }
}

