/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.utils.Validate;

public final class SigV4SignerDefaults {
    private final String service;
    private final String authType;
    private final String schemeId;
    private final Boolean doubleUrlEncode;
    private final Boolean normalizePath;
    private final Boolean payloadSigningEnabled;
    private final Boolean chunkEncodingEnabled;
    private final Map<String, SigV4SignerDefaults> operations;

    private SigV4SignerDefaults(Builder builder) {
        this.service = builder.service;
        this.authType = (String)Validate.notNull((Object)builder.authType, (String)"authType", (Object[])new Object[0]);
        this.schemeId = (String)Validate.notNull((Object)builder.schemeId, (String)"schemeId", (Object[])new Object[0]);
        this.doubleUrlEncode = builder.doubleUrlEncode;
        this.normalizePath = builder.normalizePath;
        this.payloadSigningEnabled = builder.payloadSigningEnabled;
        this.chunkEncodingEnabled = builder.chunkEncodingEnabled;
        this.operations = Collections.unmodifiableMap(new HashMap(builder.operations));
    }

    public boolean isServiceOverrideAuthScheme() {
        return this.service != null;
    }

    public String service() {
        return this.service;
    }

    public String authType() {
        return this.authType;
    }

    public String schemeId() {
        return this.schemeId;
    }

    public Boolean doubleUrlEncode() {
        return this.doubleUrlEncode;
    }

    public Boolean normalizePath() {
        return this.normalizePath;
    }

    public Boolean payloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public Boolean chunkEncodingEnabled() {
        return this.chunkEncodingEnabled;
    }

    public Map<String, SigV4SignerDefaults> operations() {
        return this.operations;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SigV4SignerDefaults defaults = (SigV4SignerDefaults)o;
        if (!Objects.equals(this.service, defaults.service)) {
            return false;
        }
        if (!this.authType.equals(defaults.authType)) {
            return false;
        }
        if (!this.schemeId.equals(defaults.schemeId)) {
            return false;
        }
        if (!Objects.equals(this.doubleUrlEncode, defaults.doubleUrlEncode)) {
            return false;
        }
        if (!Objects.equals(this.normalizePath, defaults.normalizePath)) {
            return false;
        }
        if (!Objects.equals(this.payloadSigningEnabled, defaults.payloadSigningEnabled)) {
            return false;
        }
        if (!Objects.equals(this.chunkEncodingEnabled, defaults.chunkEncodingEnabled)) {
            return false;
        }
        return this.operations.equals(defaults.operations);
    }

    public int hashCode() {
        int result = this.service != null ? this.service.hashCode() : 0;
        result = 31 * result + this.authType.hashCode();
        result = 31 * result + this.schemeId.hashCode();
        result = 31 * result + (this.doubleUrlEncode != null ? this.doubleUrlEncode.hashCode() : 0);
        result = 31 * result + (this.normalizePath != null ? this.normalizePath.hashCode() : 0);
        result = 31 * result + (this.payloadSigningEnabled != null ? this.payloadSigningEnabled.hashCode() : 0);
        result = 31 * result + (this.chunkEncodingEnabled != null ? this.chunkEncodingEnabled.hashCode() : 0);
        result = 31 * result + this.operations.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String authType;
        private String service;
        private String schemeId;
        private Boolean doubleUrlEncode;
        private Boolean normalizePath;
        private Boolean payloadSigningEnabled;
        private Boolean chunkEncodingEnabled;
        private Map<String, SigV4SignerDefaults> operations = new HashMap<String, SigV4SignerDefaults>();

        public Builder() {
        }

        public Builder(SigV4SignerDefaults other) {
            this.service = other.service;
            this.authType = (String)Validate.notNull((Object)other.authType, (String)"name", (Object[])new Object[0]);
            this.schemeId = (String)Validate.notNull((Object)other.schemeId, (String)"schemeId", (Object[])new Object[0]);
            this.doubleUrlEncode = other.doubleUrlEncode;
            this.normalizePath = other.normalizePath;
            this.payloadSigningEnabled = other.payloadSigningEnabled;
            this.chunkEncodingEnabled = other.chunkEncodingEnabled;
            this.operations.putAll(other.operations);
        }

        public String service() {
            return this.service;
        }

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public String authType() {
            return this.authType;
        }

        public Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        public String schemeId() {
            return this.schemeId;
        }

        public Builder schemeId(String schemeId) {
            this.schemeId = schemeId;
            return this;
        }

        public Boolean doubleUrlEncode() {
            return this.doubleUrlEncode;
        }

        public Builder doubleUrlEncode(Boolean doubleUrlEncode) {
            this.doubleUrlEncode = doubleUrlEncode;
            return this;
        }

        public Boolean normalizePath() {
            return this.normalizePath;
        }

        public Builder normalizePath(Boolean normalizePath) {
            this.normalizePath = normalizePath;
            return this;
        }

        public Boolean payloadSigningEnabled() {
            return this.payloadSigningEnabled;
        }

        public Builder payloadSigningEnabled(Boolean payloadSigningEnabled) {
            this.payloadSigningEnabled = payloadSigningEnabled;
            return this;
        }

        public Boolean chunkEncodingEnabled() {
            return this.chunkEncodingEnabled;
        }

        public Builder chunkEncodingEnabled(Boolean chunkEncodingEnabled) {
            this.chunkEncodingEnabled = chunkEncodingEnabled;
            return this;
        }

        public Map<String, SigV4SignerDefaults> operations() {
            return this.operations;
        }

        public Builder putOperation(String name, SigV4SignerDefaults constants) {
            this.operations.put(name, constants);
            return this;
        }

        public SigV4SignerDefaults build() {
            return new SigV4SignerDefaults(this);
        }
    }
}

