/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet;

import com.squareup.javapoet.CodeBlock;
import java.util.stream.Collector;

public final class PoetCollectors {
    private PoetCollectors() {
    }

    public static Collector<CodeBlock, ?, CodeBlock> toCodeBlock() {
        return Collector.of(CodeBlock::builder, CodeBlock.Builder::add, (xva$0, xva$1) -> (CodeBlock.Builder)PoetCollectors.parallelNotSupported(xva$0, xva$1), CodeBlock.Builder::build, new Collector.Characteristics[0]);
    }

    public static Collector<CodeBlock, ?, CodeBlock> toDelimitedCodeBlock(String delimiter) {
        return Collector.of(() -> new CodeBlockJoiner(delimiter), (rec$, x$0) -> ((CodeBlockJoiner)rec$).add(x$0), (xva$0, xva$1) -> (CodeBlockJoiner)PoetCollectors.parallelNotSupported(xva$0, xva$1), rec$ -> ((CodeBlockJoiner)rec$).join(), new Collector.Characteristics[0]);
    }

    private static <T> T parallelNotSupported(Object ... ignoredParams) {
        throw new UnsupportedOperationException("Parallel collecting is not supported.");
    }

    private static class CodeBlockJoiner {
        private final CodeBlock.Builder builder = CodeBlock.builder();
        private final String delimiter;
        private boolean builderEmpty = true;

        private CodeBlockJoiner(String delimiter) {
            this.delimiter = delimiter;
        }

        private void add(CodeBlock block) {
            if (!this.builderEmpty) {
                this.builder.add(CodeBlock.of((String)this.delimiter, (Object[])new Object[0]));
            } else {
                this.builderEmpty = false;
            }
            this.builder.add(block);
        }

        private CodeBlock join() {
            return this.builder.build();
        }
    }
}

